/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class InvalidationCompleted {
    InvalidationCompleted() {
    }

    static class IsCompletedMatcher
    extends WaiterAcceptor<GetInvalidationResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsCompletedMatcher() {
        }

        public boolean matches(GetInvalidationResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"Completed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("invalidation.status");
        }
    }
}

