/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;

public class S3OriginConfigUnmarshaller
implements Unmarshaller<S3OriginConfig, StaxUnmarshallerContext> {
    private static final S3OriginConfigUnmarshaller INSTANCE = new S3OriginConfigUnmarshaller();

    public S3OriginConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3OriginConfig.Builder s3OriginConfig = S3OriginConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("OriginAccessIdentity", targetDepth)) continue;
                s3OriginConfig.originAccessIdentity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3OriginConfig)s3OriginConfig.build();
    }

    public static S3OriginConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

