/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.transform.CustomErrorResponseUnmarshaller;

public class CustomErrorResponsesUnmarshaller
implements Unmarshaller<CustomErrorResponses, StaxUnmarshallerContext> {
    private static final CustomErrorResponsesUnmarshaller INSTANCE = new CustomErrorResponsesUnmarshaller();

    public CustomErrorResponses unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomErrorResponses.Builder customErrorResponses;
        block6: {
            customErrorResponses = CustomErrorResponses.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<CustomErrorResponse> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    customErrorResponses.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        customErrorResponses.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<CustomErrorResponse>();
                        continue;
                    }
                    if (!context.testExpression("Items/CustomErrorResponse", targetDepth)) continue;
                    items.add(CustomErrorResponseUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            customErrorResponses.items(items);
        }
        return (CustomErrorResponses)customErrorResponses.build();
    }

    public static CustomErrorResponsesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

