/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;

public class InvalidationSummaryUnmarshaller
implements Unmarshaller<InvalidationSummary, StaxUnmarshallerContext> {
    private static InvalidationSummaryUnmarshaller INSTANCE;

    public InvalidationSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InvalidationSummary.Builder invalidationSummary = InvalidationSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    invalidationSummary.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    invalidationSummary.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                invalidationSummary.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InvalidationSummary)invalidationSummary.build();
    }

    public static InvalidationSummaryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InvalidationSummaryUnmarshaller();
        }
        return INSTANCE;
    }
}

