/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig;

public class StreamingLoggingConfigUnmarshaller
implements Unmarshaller<StreamingLoggingConfig, StaxUnmarshallerContext> {
    private static final StreamingLoggingConfigUnmarshaller INSTANCE = new StreamingLoggingConfigUnmarshaller();

    public StreamingLoggingConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StreamingLoggingConfig.Builder streamingLoggingConfig = StreamingLoggingConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    streamingLoggingConfig.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    streamingLoggingConfig.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Prefix", targetDepth)) continue;
                streamingLoggingConfig.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StreamingLoggingConfig)streamingLoggingConfig.build();
    }

    public static StreamingLoggingConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

