/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;

public class ListDistributionsByWebAclIdRequestMarshaller
implements Marshaller<Request<ListDistributionsByWebAclIdRequest>, ListDistributionsByWebAclIdRequest> {
    public Request<ListDistributionsByWebAclIdRequest> marshall(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        if (listDistributionsByWebAclIdRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listDistributionsByWebAclIdRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distributionsByWebACLId/{WebACLId}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "WebACLId", listDistributionsByWebAclIdRequest.webACLId());
        request.setResourcePath(uriResourcePath);
        if (listDistributionsByWebAclIdRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)listDistributionsByWebAclIdRequest.marker()));
        }
        if (listDistributionsByWebAclIdRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringConversion.fromString((String)listDistributionsByWebAclIdRequest.maxItems()));
        }
        return request;
    }
}

