/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;

public class GetInvalidationRequestMarshaller
implements Marshaller<Request<GetInvalidationRequest>, GetInvalidationRequest> {
    public Request<GetInvalidationRequest> marshall(GetInvalidationRequest getInvalidationRequest) {
        if (getInvalidationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getInvalidationRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution/{DistributionId}/invalidation/{Id}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "DistributionId", getInvalidationRequest.distributionId());
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Id", getInvalidationRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

