/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByWebAclIdRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDistributionsByWebAclIdRequest> {
    private final String marker;
    private final String maxItems;
    private final String webACLId;

    private ListDistributionsByWebAclIdRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.webACLId = builder.webACLId;
    }

    public String marker() {
        return this.marker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public String webACLId() {
        return this.webACLId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByWebAclIdRequest)) {
            return false;
        }
        ListDistributionsByWebAclIdRequest other = (ListDistributionsByWebAclIdRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.webACLId(), other.webACLId());
    }

    public String toString() {
        return ToString.builder((String)"ListDistributionsByWebAclIdRequest").add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).add("WebACLId", (Object)this.webACLId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String marker;
        private String maxItems;
        private String webACLId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByWebAclIdRequest model) {
            super(model);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
            this.webACLId(model.webACLId);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByWebAclIdRequest build() {
            return new ListDistributionsByWebAclIdRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, ListDistributionsByWebAclIdRequest> {
        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder webACLId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

