/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionList
implements ToCopyableBuilder<Builder, DistributionList> {
    private final String marker;
    private final String nextMarker;
    private final Integer maxItems;
    private final Boolean isTruncated;
    private final Integer quantity;
    private final List<DistributionSummary> items;

    private DistributionList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public String marker() {
        return this.marker;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<DistributionSummary> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionList)) {
            return false;
        }
        DistributionList other = (DistributionList)obj;
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"DistributionList").add("Marker", (Object)this.marker()).add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).add("IsTruncated", (Object)this.isTruncated()).add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private String nextMarker;
        private Integer maxItems;
        private Boolean isTruncated;
        private Integer quantity;
        private List<DistributionSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionList model) {
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
            this.isTruncated(model.isTruncated);
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<DistributionSummary.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(DistributionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<DistributionSummary> items) {
            this.items = DistributionSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DistributionSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DistributionSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (DistributionSummary)((DistributionSummary.Builder)DistributionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<DistributionSummary.BuilderImpl> items) {
            this.items = DistributionSummaryListCopier.copyFromBuilder(items);
        }

        public DistributionList build() {
            return new DistributionList(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DistributionList> {
        public Builder marker(String var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<DistributionSummary> var1);

        public Builder items(DistributionSummary ... var1);

        public Builder items(Consumer<DistributionSummary.Builder> ... var1);
    }
}

