/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.HttpVersion;
import software.amazon.awssdk.services.cloudfront.model.LoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionConfig
implements ToCopyableBuilder<Builder, DistributionConfig> {
    private final String callerReference;
    private final Aliases aliases;
    private final String defaultRootObject;
    private final Origins origins;
    private final DefaultCacheBehavior defaultCacheBehavior;
    private final CacheBehaviors cacheBehaviors;
    private final CustomErrorResponses customErrorResponses;
    private final String comment;
    private final LoggingConfig logging;
    private final String priceClass;
    private final Boolean enabled;
    private final ViewerCertificate viewerCertificate;
    private final Restrictions restrictions;
    private final String webACLId;
    private final String httpVersion;
    private final Boolean isIPV6Enabled;

    private DistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.aliases = builder.aliases;
        this.defaultRootObject = builder.defaultRootObject;
        this.origins = builder.origins;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public String defaultRootObject() {
        return this.defaultRootObject;
    }

    public Origins origins() {
        return this.origins;
    }

    public DefaultCacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CacheBehaviors cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public CustomErrorResponses customErrorResponses() {
        return this.customErrorResponses;
    }

    public String comment() {
        return this.comment;
    }

    public LoggingConfig logging() {
        return this.logging;
    }

    public PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public String priceClassAsString() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public ViewerCertificate viewerCertificate() {
        return this.viewerCertificate;
    }

    public Restrictions restrictions() {
        return this.restrictions;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public HttpVersion httpVersion() {
        return HttpVersion.fromValue(this.httpVersion);
    }

    public String httpVersionAsString() {
        return this.httpVersion;
    }

    public Boolean isIPV6Enabled() {
        return this.isIPV6Enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRootObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIPV6Enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfig)) {
            return false;
        }
        DistributionConfig other = (DistributionConfig)obj;
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.defaultRootObject(), other.defaultRootObject()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.customErrorResponses(), other.customErrorResponses()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.viewerCertificate(), other.viewerCertificate()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.httpVersionAsString(), other.httpVersionAsString()) && Objects.equals(this.isIPV6Enabled(), other.isIPV6Enabled());
    }

    public String toString() {
        return ToString.builder((String)"DistributionConfig").add("CallerReference", (Object)this.callerReference()).add("Aliases", (Object)this.aliases()).add("DefaultRootObject", (Object)this.defaultRootObject()).add("Origins", (Object)this.origins()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviors", (Object)this.cacheBehaviors()).add("CustomErrorResponses", (Object)this.customErrorResponses()).add("Comment", (Object)this.comment()).add("Logging", (Object)this.logging()).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).add("ViewerCertificate", (Object)this.viewerCertificate()).add("Restrictions", (Object)this.restrictions()).add("WebACLId", (Object)this.webACLId()).add("HttpVersion", (Object)this.httpVersionAsString()).add("IsIPV6Enabled", (Object)this.isIPV6Enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "DefaultRootObject": {
                return Optional.ofNullable(clazz.cast(this.defaultRootObject()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "DefaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "CacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "CustomErrorResponses": {
                return Optional.ofNullable(clazz.cast(this.customErrorResponses()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "PriceClass": {
                return Optional.ofNullable(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ViewerCertificate": {
                return Optional.ofNullable(clazz.cast(this.viewerCertificate()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "HttpVersion": {
                return Optional.ofNullable(clazz.cast(this.httpVersionAsString()));
            }
            case "IsIPV6Enabled": {
                return Optional.ofNullable(clazz.cast(this.isIPV6Enabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private Aliases aliases;
        private String defaultRootObject;
        private Origins origins;
        private DefaultCacheBehavior defaultCacheBehavior;
        private CacheBehaviors cacheBehaviors;
        private CustomErrorResponses customErrorResponses;
        private String comment;
        private LoggingConfig logging;
        private String priceClass;
        private Boolean enabled;
        private ViewerCertificate viewerCertificate;
        private Restrictions restrictions;
        private String webACLId;
        private String httpVersion;
        private Boolean isIPV6Enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfig model) {
            this.callerReference(model.callerReference);
            this.aliases(model.aliases);
            this.defaultRootObject(model.defaultRootObject);
            this.origins(model.origins);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviors(model.cacheBehaviors);
            this.customErrorResponses(model.customErrorResponses);
            this.comment(model.comment);
            this.logging(model.logging);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
            this.viewerCertificate(model.viewerCertificate);
            this.restrictions(model.restrictions);
            this.webACLId(model.webACLId);
            this.httpVersion(model.httpVersion);
            this.isIPV6Enabled(model.isIPV6Enabled);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final String getDefaultRootObject() {
            return this.defaultRootObject;
        }

        @Override
        public final Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public final void setDefaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
        }

        public final Origins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return this.cacheBehaviors != null ? this.cacheBehaviors.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return this.customErrorResponses != null ? this.customErrorResponses.toBuilder() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final LoggingConfig.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(LoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(LoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return this.viewerCertificate != null ? this.viewerCertificate.toBuilder() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        public final Restrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersion() {
            return this.httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return this.isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        public DistributionConfig build() {
            return new DistributionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DistributionConfig> {
        public Builder callerReference(String var1);

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().applyMutation(aliases)).build());
        }

        public Builder defaultRootObject(String var1);

        public Builder origins(Origins var1);

        default public Builder origins(Consumer<Origins.Builder> origins) {
            return this.origins((Origins)((Origins.Builder)Origins.builder().applyMutation(origins)).build());
        }

        public Builder defaultCacheBehavior(DefaultCacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((DefaultCacheBehavior)((DefaultCacheBehavior.Builder)DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviors(CacheBehaviors var1);

        default public Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return this.cacheBehaviors((CacheBehaviors)((CacheBehaviors.Builder)CacheBehaviors.builder().applyMutation(cacheBehaviors)).build());
        }

        public Builder customErrorResponses(CustomErrorResponses var1);

        default public Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return this.customErrorResponses((CustomErrorResponses)((CustomErrorResponses.Builder)CustomErrorResponses.builder().applyMutation(customErrorResponses)).build());
        }

        public Builder comment(String var1);

        public Builder logging(LoggingConfig var1);

        default public Builder logging(Consumer<LoggingConfig.Builder> logging) {
            return this.logging((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(logging)).build());
        }

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);

        public Builder viewerCertificate(ViewerCertificate var1);

        default public Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return this.viewerCertificate((ViewerCertificate)((ViewerCertificate.Builder)ViewerCertificate.builder().applyMutation(viewerCertificate)).build());
        }

        public Builder restrictions(Restrictions var1);

        default public Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return this.restrictions((Restrictions)((Restrictions.Builder)Restrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder webACLId(String var1);

        public Builder httpVersion(String var1);

        public Builder httpVersion(HttpVersion var1);

        public Builder isIPV6Enabled(Boolean var1);
    }
}

