/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CachedMethods;
import software.amazon.awssdk.services.cloudfront.model.Method;
import software.amazon.awssdk.services.cloudfront.model.MethodsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllowedMethods
implements ToCopyableBuilder<Builder, AllowedMethods> {
    private final Integer quantity;
    private final List<String> items;
    private final CachedMethods cachedMethods;

    private AllowedMethods(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
        this.cachedMethods = builder.cachedMethods;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<Method> items() {
        return TypeConverter.convert(this.items, Method::fromValue);
    }

    public List<String> itemsAsStrings() {
        return this.items;
    }

    public CachedMethods cachedMethods() {
        return this.cachedMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachedMethods());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedMethods)) {
            return false;
        }
        AllowedMethods other = (AllowedMethods)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.itemsAsStrings(), other.itemsAsStrings()) && Objects.equals(this.cachedMethods(), other.cachedMethods());
    }

    public String toString() {
        return ToString.builder((String)"AllowedMethods").add("Quantity", (Object)this.quantity()).add("Items", this.itemsAsStrings()).add("CachedMethods", (Object)this.cachedMethods()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.itemsAsStrings()));
            }
            case "CachedMethods": {
                return Optional.ofNullable(clazz.cast(this.cachedMethods()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();
        private CachedMethods cachedMethods;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedMethods model) {
            this.quantity(model.quantity);
            this.itemsWithStrings(model.items);
            this.cachedMethods(model.cachedMethods);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder itemsWithStrings(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemsWithStrings(String ... items) {
            this.itemsWithStrings(Arrays.asList(items));
            return this;
        }

        @Override
        public final Builder items(Collection<Method> items) {
            this.items = MethodsListCopier.copyEnumToString(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Method ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
        }

        public final CachedMethods.Builder getCachedMethods() {
            return this.cachedMethods != null ? this.cachedMethods.toBuilder() : null;
        }

        @Override
        public final Builder cachedMethods(CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        public final void setCachedMethods(CachedMethods.BuilderImpl cachedMethods) {
            this.cachedMethods = cachedMethods != null ? cachedMethods.build() : null;
        }

        public AllowedMethods build() {
            return new AllowedMethods(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AllowedMethods> {
        public Builder quantity(Integer var1);

        public Builder itemsWithStrings(Collection<String> var1);

        public Builder itemsWithStrings(String ... var1);

        public Builder items(Collection<Method> var1);

        public Builder items(Method ... var1);

        public Builder cachedMethods(CachedMethods var1);

        default public Builder cachedMethods(Consumer<CachedMethods.Builder> cachedMethods) {
            return this.cachedMethods((CachedMethods)((CachedMethods.Builder)CachedMethods.builder().applyMutation(cachedMethods)).build());
        }
    }
}

