/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.SslProtocol;
import software.amazon.awssdk.services.cloudfront.model.SslProtocolsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginSslProtocols
implements ToCopyableBuilder<Builder, OriginSslProtocols> {
    private final Integer quantity;
    private final List<String> items;

    private OriginSslProtocols(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<SslProtocol> items() {
        return TypeConverter.convert(this.items, SslProtocol::fromValue);
    }

    public List<String> itemsAsStrings() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginSslProtocols)) {
            return false;
        }
        OriginSslProtocols other = (OriginSslProtocols)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.itemsAsStrings(), other.itemsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"OriginSslProtocols").add("Quantity", (Object)this.quantity()).add("Items", this.itemsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.itemsAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OriginSslProtocols model) {
            this.quantity(model.quantity);
            this.itemsWithStrings(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder itemsWithStrings(Collection<String> items) {
            this.items = SslProtocolsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemsWithStrings(String ... items) {
            this.itemsWithStrings(Arrays.asList(items));
            return this;
        }

        @Override
        public final Builder items(Collection<SslProtocol> items) {
            this.items = SslProtocolsListCopier.copyEnumToString(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(SslProtocol ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = SslProtocolsListCopier.copy(items);
        }

        public OriginSslProtocols build() {
            return new OriginSslProtocols(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OriginSslProtocols> {
        public Builder quantity(Integer var1);

        public Builder itemsWithStrings(Collection<String> var1);

        public Builder itemsWithStrings(String ... var1);

        public Builder items(Collection<SslProtocol> var1);

        public Builder items(SslProtocol ... var1);
    }
}

