/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;

public class DeleteDistributionRequestMarshaller
implements Marshaller<Request<DeleteDistributionRequest>, DeleteDistributionRequest> {
    public Request<DeleteDistributionRequest> marshall(DeleteDistributionRequest deleteDistributionRequest) {
        if (deleteDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDistributionRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteDistributionRequest.ifMatch()));
        }
        String uriResourcePath = "/2017-03-25/distribution/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", deleteDistributionRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

