/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamingDistributionSummary
implements ToCopyableBuilder<Builder, StreamingDistributionSummary> {
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final S3Origin s3Origin;
    private final Aliases aliases;
    private final TrustedSigners trustedSigners;
    private final String comment;
    private final String priceClass;
    private final Boolean enabled;

    private StreamingDistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.trustedSigners = builder.trustedSigners;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String domainName() {
        return this.domainName;
    }

    public S3Origin s3Origin() {
        return this.s3Origin;
    }

    public Aliases aliases() {
        return this.aliases;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public String comment() {
        return this.comment;
    }

    public PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public String priceClassAsString() {
        return this.priceClass;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionSummary)) {
            return false;
        }
        StreamingDistributionSummary other = (StreamingDistributionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.s3Origin(), other.s3Origin()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.trustedSigners(), other.trustedSigners()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"StreamingDistributionSummary").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DomainName", (Object)this.domainName()).add("S3Origin", (Object)this.s3Origin()).add("Aliases", (Object)this.aliases()).add("TrustedSigners", (Object)this.trustedSigners()).add("Comment", (Object)this.comment()).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.of(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "S3Origin": {
                return Optional.of(clazz.cast(this.s3Origin()));
            }
            case "Aliases": {
                return Optional.of(clazz.cast(this.aliases()));
            }
            case "TrustedSigners": {
                return Optional.of(clazz.cast(this.trustedSigners()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "PriceClass": {
                return Optional.of(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private S3Origin s3Origin;
        private Aliases aliases;
        private TrustedSigners trustedSigners;
        private String comment;
        private String priceClass;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.s3Origin(model.s3Origin);
            this.aliases(model.aliases);
            this.trustedSigners(model.trustedSigners);
            this.comment(model.comment);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final S3Origin.Builder getS3Origin() {
            return this.s3Origin != null ? this.s3Origin.toBuilder() : null;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return this.trustedSigners != null ? this.trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public StreamingDistributionSummary build() {
            return new StreamingDistributionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamingDistributionSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder s3Origin(S3Origin var1);

        default public Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return this.s3Origin((S3Origin)((S3Origin.Builder)S3Origin.builder().apply(s3Origin)).build());
        }

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().apply(aliases)).build());
        }

        public Builder trustedSigners(TrustedSigners var1);

        default public Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return this.trustedSigners((TrustedSigners)((TrustedSigners.Builder)TrustedSigners.builder().apply(trustedSigners)).build());
        }

        public Builder comment(String var1);

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);
    }
}

