/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.TagKeys;

public class TagKeysUnmarshaller
implements Unmarshaller<TagKeys, StaxUnmarshallerContext> {
    private static TagKeysUnmarshaller INSTANCE;

    public TagKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TagKeys.Builder tagKeys = TagKeys.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Items", targetDepth)) {
                    tagKeys.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Key", targetDepth)) continue;
                tagKeys.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TagKeys)tagKeys.build();
    }

    public static TagKeysUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagKeysUnmarshaller();
        }
        return INSTANCE;
    }
}

