/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ScanFilter;
import software.amazon.awssdk.services.cloudformation.model.ScanFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartResourceScanRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, StartResourceScanRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartResourceScanRequest.getter(StartResourceScanRequest::clientRequestToken)).setter(StartResourceScanRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<List<ScanFilter>> SCAN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScanFilters").getter(StartResourceScanRequest.getter(StartResourceScanRequest::scanFilters)).setter(StartResourceScanRequest.setter(Builder::scanFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, SCAN_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartResourceScanRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final List<ScanFilter> scanFilters;

    private StartResourceScanRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.scanFilters = builder.scanFilters;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasScanFilters() {
        return this.scanFilters != null && !(this.scanFilters instanceof SdkAutoConstructList);
    }

    public final List<ScanFilter> scanFilters() {
        return this.scanFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanFilters() ? this.scanFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceScanRequest)) {
            return false;
        }
        StartResourceScanRequest other = (StartResourceScanRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasScanFilters() == other.hasScanFilters() && Objects.equals(this.scanFilters(), other.scanFilters());
    }

    public final String toString() {
        return ToString.builder((String)"StartResourceScanRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("ScanFilters", this.hasScanFilters() ? this.scanFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ScanFilters": {
                return Optional.ofNullable(clazz.cast(this.scanFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ScanFilters", SCAN_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartResourceScanRequest, T> g) {
        return obj -> g.apply((StartResourceScanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private List<ScanFilter> scanFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceScanRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.scanFilters(model.scanFilters);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<ScanFilter.Builder> getScanFilters() {
            List<ScanFilter.Builder> result = ScanFiltersCopier.copyToBuilder(this.scanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanFilters(Collection<ScanFilter.BuilderImpl> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copyFromBuilder(scanFilters);
        }

        @Override
        public final Builder scanFilters(Collection<ScanFilter> scanFilters) {
            this.scanFilters = ScanFiltersCopier.copy(scanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(ScanFilter ... scanFilters) {
            this.scanFilters(Arrays.asList(scanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanFilters(Consumer<ScanFilter.Builder> ... scanFilters) {
            this.scanFilters(Stream.of(scanFilters).map(c -> (ScanFilter)((ScanFilter.Builder)ScanFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartResourceScanRequest build() {
            return new StartResourceScanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartResourceScanRequest> {
        public Builder clientRequestToken(String var1);

        public Builder scanFilters(Collection<ScanFilter> var1);

        public Builder scanFilters(ScanFilter ... var1);

        public Builder scanFilters(Consumer<ScanFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

