/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode;
import software.amazon.awssdk.services.cloudformation.model.OperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordHandlerProgressRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, RecordHandlerProgressRequest> {
    private static final SdkField<String> BEARER_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BearerToken").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::bearerToken)).setter(RecordHandlerProgressRequest.setter(Builder::bearerToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BearerToken").build()}).build();
    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationStatus").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::operationStatusAsString)).setter(RecordHandlerProgressRequest.setter(Builder::operationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()}).build();
    private static final SdkField<String> CURRENT_OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentOperationStatus").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::currentOperationStatusAsString)).setter(RecordHandlerProgressRequest.setter(Builder::currentOperationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentOperationStatus").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::statusMessage)).setter(RecordHandlerProgressRequest.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::errorCodeAsString)).setter(RecordHandlerProgressRequest.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> RESOURCE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceModel").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::resourceModel)).setter(RecordHandlerProgressRequest.setter(Builder::resourceModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceModel").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(RecordHandlerProgressRequest.getter(RecordHandlerProgressRequest::clientRequestToken)).setter(RecordHandlerProgressRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEARER_TOKEN_FIELD, OPERATION_STATUS_FIELD, CURRENT_OPERATION_STATUS_FIELD, STATUS_MESSAGE_FIELD, ERROR_CODE_FIELD, RESOURCE_MODEL_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordHandlerProgressRequest.memberNameToFieldInitializer();
    private final String bearerToken;
    private final String operationStatus;
    private final String currentOperationStatus;
    private final String statusMessage;
    private final String errorCode;
    private final String resourceModel;
    private final String clientRequestToken;

    private RecordHandlerProgressRequest(BuilderImpl builder) {
        super(builder);
        this.bearerToken = builder.bearerToken;
        this.operationStatus = builder.operationStatus;
        this.currentOperationStatus = builder.currentOperationStatus;
        this.statusMessage = builder.statusMessage;
        this.errorCode = builder.errorCode;
        this.resourceModel = builder.resourceModel;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String bearerToken() {
        return this.bearerToken;
    }

    public final OperationStatus operationStatus() {
        return OperationStatus.fromValue(this.operationStatus);
    }

    public final String operationStatusAsString() {
        return this.operationStatus;
    }

    public final OperationStatus currentOperationStatus() {
        return OperationStatus.fromValue(this.currentOperationStatus);
    }

    public final String currentOperationStatusAsString() {
        return this.currentOperationStatus;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final HandlerErrorCode errorCode() {
        return HandlerErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String resourceModel() {
        return this.resourceModel;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bearerToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordHandlerProgressRequest)) {
            return false;
        }
        RecordHandlerProgressRequest other = (RecordHandlerProgressRequest)((Object)obj);
        return Objects.equals(this.bearerToken(), other.bearerToken()) && Objects.equals(this.operationStatusAsString(), other.operationStatusAsString()) && Objects.equals(this.currentOperationStatusAsString(), other.currentOperationStatusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.resourceModel(), other.resourceModel()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"RecordHandlerProgressRequest").add("BearerToken", (Object)this.bearerToken()).add("OperationStatus", (Object)this.operationStatusAsString()).add("CurrentOperationStatus", (Object)this.currentOperationStatusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ResourceModel", (Object)this.resourceModel()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BearerToken": {
                return Optional.ofNullable(clazz.cast(this.bearerToken()));
            }
            case "OperationStatus": {
                return Optional.ofNullable(clazz.cast(this.operationStatusAsString()));
            }
            case "CurrentOperationStatus": {
                return Optional.ofNullable(clazz.cast(this.currentOperationStatusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ResourceModel": {
                return Optional.ofNullable(clazz.cast(this.resourceModel()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BearerToken", BEARER_TOKEN_FIELD);
        map.put("OperationStatus", OPERATION_STATUS_FIELD);
        map.put("CurrentOperationStatus", CURRENT_OPERATION_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ResourceModel", RESOURCE_MODEL_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordHandlerProgressRequest, T> g) {
        return obj -> g.apply((RecordHandlerProgressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String bearerToken;
        private String operationStatus;
        private String currentOperationStatus;
        private String statusMessage;
        private String errorCode;
        private String resourceModel;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordHandlerProgressRequest model) {
            super(model);
            this.bearerToken(model.bearerToken);
            this.operationStatus(model.operationStatus);
            this.currentOperationStatus(model.currentOperationStatus);
            this.statusMessage(model.statusMessage);
            this.errorCode(model.errorCode);
            this.resourceModel(model.resourceModel);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getBearerToken() {
            return this.bearerToken;
        }

        public final void setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
        }

        @Override
        public final Builder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public final String getOperationStatus() {
            return this.operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final String getCurrentOperationStatus() {
            return this.currentOperationStatus;
        }

        public final void setCurrentOperationStatus(String currentOperationStatus) {
            this.currentOperationStatus = currentOperationStatus;
        }

        @Override
        public final Builder currentOperationStatus(String currentOperationStatus) {
            this.currentOperationStatus = currentOperationStatus;
            return this;
        }

        @Override
        public final Builder currentOperationStatus(OperationStatus currentOperationStatus) {
            this.currentOperationStatus(currentOperationStatus == null ? null : currentOperationStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(HandlerErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getResourceModel() {
            return this.resourceModel;
        }

        public final void setResourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
        }

        @Override
        public final Builder resourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecordHandlerProgressRequest build() {
            return new RecordHandlerProgressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RecordHandlerProgressRequest> {
        public Builder bearerToken(String var1);

        public Builder operationStatus(String var1);

        public Builder operationStatus(OperationStatus var1);

        public Builder currentOperationStatus(String var1);

        public Builder currentOperationStatus(OperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(HandlerErrorCode var1);

        public Builder resourceModel(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

