/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiveResourceDrift
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveResourceDrift> {
    private static final SdkField<String> PREVIOUS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousValue").getter(LiveResourceDrift.getter(LiveResourceDrift::previousValue)).setter(LiveResourceDrift.setter(Builder::previousValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()}).build();
    private static final SdkField<String> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActualValue").getter(LiveResourceDrift.getter(LiveResourceDrift::actualValue)).setter(LiveResourceDrift.setter(Builder::actualValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()}).build();
    private static final SdkField<Instant> DRIFT_DETECTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DriftDetectionTimestamp").getter(LiveResourceDrift.getter(LiveResourceDrift::driftDetectionTimestamp)).setter(LiveResourceDrift.setter(Builder::driftDetectionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftDetectionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIOUS_VALUE_FIELD, ACTUAL_VALUE_FIELD, DRIFT_DETECTION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiveResourceDrift.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String previousValue;
    private final String actualValue;
    private final Instant driftDetectionTimestamp;

    private LiveResourceDrift(BuilderImpl builder) {
        this.previousValue = builder.previousValue;
        this.actualValue = builder.actualValue;
        this.driftDetectionTimestamp = builder.driftDetectionTimestamp;
    }

    public final String previousValue() {
        return this.previousValue;
    }

    public final String actualValue() {
        return this.actualValue;
    }

    public final Instant driftDetectionTimestamp() {
        return this.driftDetectionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftDetectionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveResourceDrift)) {
            return false;
        }
        LiveResourceDrift other = (LiveResourceDrift)obj;
        return Objects.equals(this.previousValue(), other.previousValue()) && Objects.equals(this.actualValue(), other.actualValue()) && Objects.equals(this.driftDetectionTimestamp(), other.driftDetectionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"LiveResourceDrift").add("PreviousValue", (Object)this.previousValue()).add("ActualValue", (Object)this.actualValue()).add("DriftDetectionTimestamp", (Object)this.driftDetectionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreviousValue": {
                return Optional.ofNullable(clazz.cast(this.previousValue()));
            }
            case "ActualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValue()));
            }
            case "DriftDetectionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.driftDetectionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PreviousValue", PREVIOUS_VALUE_FIELD);
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("DriftDetectionTimestamp", DRIFT_DETECTION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveResourceDrift, T> g) {
        return obj -> g.apply((LiveResourceDrift)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String previousValue;
        private String actualValue;
        private Instant driftDetectionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveResourceDrift model) {
            this.previousValue(model.previousValue);
            this.actualValue(model.actualValue);
            this.driftDetectionTimestamp(model.driftDetectionTimestamp);
        }

        public final String getPreviousValue() {
            return this.previousValue;
        }

        public final void setPreviousValue(String previousValue) {
            this.previousValue = previousValue;
        }

        @Override
        public final Builder previousValue(String previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final String getActualValue() {
            return this.actualValue;
        }

        public final void setActualValue(String actualValue) {
            this.actualValue = actualValue;
        }

        @Override
        public final Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final Instant getDriftDetectionTimestamp() {
            return this.driftDetectionTimestamp;
        }

        public final void setDriftDetectionTimestamp(Instant driftDetectionTimestamp) {
            this.driftDetectionTimestamp = driftDetectionTimestamp;
        }

        @Override
        public final Builder driftDetectionTimestamp(Instant driftDetectionTimestamp) {
            this.driftDetectionTimestamp = driftDetectionTimestamp;
            return this;
        }

        public LiveResourceDrift build() {
            return new LiveResourceDrift(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveResourceDrift> {
        public Builder previousValue(String var1);

        public Builder actualValue(String var1);

        public Builder driftDetectionTimestamp(Instant var1);
    }
}

