/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DriftIgnoredReason {
    MANAGED_BY_AWS("MANAGED_BY_AWS"),
    WRITE_ONLY_PROPERTY("WRITE_ONLY_PROPERTY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DriftIgnoredReason> VALUE_MAP;
    private final String value;

    private DriftIgnoredReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DriftIgnoredReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DriftIgnoredReason> knownValues() {
        EnumSet<DriftIgnoredReason> knownValues = EnumSet.allOf(DriftIgnoredReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DriftIgnoredReason.class, DriftIgnoredReason::toString);
    }
}

