/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourceDefinition;
import software.amazon.awssdk.services.cloudformation.model.ResourceDefinitionsCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGeneratedTemplateRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, CreateGeneratedTemplateRequest> {
    private static final SdkField<List<ResourceDefinition>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(CreateGeneratedTemplateRequest.getter(CreateGeneratedTemplateRequest::resources)).setter(CreateGeneratedTemplateRequest.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GENERATED_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedTemplateName").getter(CreateGeneratedTemplateRequest.getter(CreateGeneratedTemplateRequest::generatedTemplateName)).setter(CreateGeneratedTemplateRequest.setter(Builder::generatedTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedTemplateName").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(CreateGeneratedTemplateRequest.getter(CreateGeneratedTemplateRequest::stackName)).setter(CreateGeneratedTemplateRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateConfiguration").getter(CreateGeneratedTemplateRequest.getter(CreateGeneratedTemplateRequest::templateConfiguration)).setter(CreateGeneratedTemplateRequest.setter(Builder::templateConfiguration)).constructor(TemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD, GENERATED_TEMPLATE_NAME_FIELD, STACK_NAME_FIELD, TEMPLATE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGeneratedTemplateRequest.memberNameToFieldInitializer();
    private final List<ResourceDefinition> resources;
    private final String generatedTemplateName;
    private final String stackName;
    private final TemplateConfiguration templateConfiguration;

    private CreateGeneratedTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.generatedTemplateName = builder.generatedTemplateName;
        this.stackName = builder.stackName;
        this.templateConfiguration = builder.templateConfiguration;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ResourceDefinition> resources() {
        return this.resources;
    }

    public final String generatedTemplateName() {
        return this.generatedTemplateName;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final TemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeneratedTemplateRequest)) {
            return false;
        }
        CreateGeneratedTemplateRequest other = (CreateGeneratedTemplateRequest)((Object)obj);
        return this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.generatedTemplateName(), other.generatedTemplateName()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGeneratedTemplateRequest").add("Resources", this.hasResources() ? this.resources() : null).add("GeneratedTemplateName", (Object)this.generatedTemplateName()).add("StackName", (Object)this.stackName()).add("TemplateConfiguration", (Object)this.templateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "GeneratedTemplateName": {
                return Optional.ofNullable(clazz.cast(this.generatedTemplateName()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "TemplateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Resources", RESOURCES_FIELD);
        map.put("GeneratedTemplateName", GENERATED_TEMPLATE_NAME_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("TemplateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGeneratedTemplateRequest, T> g) {
        return obj -> g.apply((CreateGeneratedTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private List<ResourceDefinition> resources = DefaultSdkAutoConstructList.getInstance();
        private String generatedTemplateName;
        private String stackName;
        private TemplateConfiguration templateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeneratedTemplateRequest model) {
            super(model);
            this.resources(model.resources);
            this.generatedTemplateName(model.generatedTemplateName);
            this.stackName(model.stackName);
            this.templateConfiguration(model.templateConfiguration);
        }

        public final List<ResourceDefinition.Builder> getResources() {
            List<ResourceDefinition.Builder> result = ResourceDefinitionsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceDefinition.BuilderImpl> resources) {
            this.resources = ResourceDefinitionsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceDefinition> resources) {
            this.resources = ResourceDefinitionsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceDefinition ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceDefinition.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ResourceDefinition)((ResourceDefinition.Builder)ResourceDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGeneratedTemplateName() {
            return this.generatedTemplateName;
        }

        public final void setGeneratedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
        }

        @Override
        public final Builder generatedTemplateName(String generatedTemplateName) {
            this.generatedTemplateName = generatedTemplateName;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGeneratedTemplateRequest build() {
            return new CreateGeneratedTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGeneratedTemplateRequest> {
        public Builder resources(Collection<ResourceDefinition> var1);

        public Builder resources(ResourceDefinition ... var1);

        public Builder resources(Consumer<ResourceDefinition.Builder> ... var1);

        public Builder generatedTemplateName(String var1);

        public Builder stackName(String var1);

        public Builder templateConfiguration(TemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((TemplateConfiguration)((TemplateConfiguration.Builder)TemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

