/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetHookResourceTargetDetails;
import software.amazon.awssdk.services.cloudformation.model.HookTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSetHookTargetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSetHookTargetDetails> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(ChangeSetHookTargetDetails.getter(ChangeSetHookTargetDetails::targetTypeAsString)).setter(ChangeSetHookTargetDetails.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<ChangeSetHookResourceTargetDetails> RESOURCE_TARGET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceTargetDetails").getter(ChangeSetHookTargetDetails.getter(ChangeSetHookTargetDetails::resourceTargetDetails)).setter(ChangeSetHookTargetDetails.setter(Builder::resourceTargetDetails)).constructor(ChangeSetHookResourceTargetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTargetDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, RESOURCE_TARGET_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSetHookTargetDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetType;
    private final ChangeSetHookResourceTargetDetails resourceTargetDetails;

    private ChangeSetHookTargetDetails(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.resourceTargetDetails = builder.resourceTargetDetails;
    }

    public final HookTargetType targetType() {
        return HookTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final ChangeSetHookResourceTargetDetails resourceTargetDetails() {
        return this.resourceTargetDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTargetDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetHookTargetDetails)) {
            return false;
        }
        ChangeSetHookTargetDetails other = (ChangeSetHookTargetDetails)obj;
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.resourceTargetDetails(), other.resourceTargetDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSetHookTargetDetails").add("TargetType", (Object)this.targetTypeAsString()).add("ResourceTargetDetails", (Object)this.resourceTargetDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "ResourceTargetDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceTargetDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("ResourceTargetDetails", RESOURCE_TARGET_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetHookTargetDetails, T> g) {
        return obj -> g.apply((ChangeSetHookTargetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetType;
        private ChangeSetHookResourceTargetDetails resourceTargetDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetHookTargetDetails model) {
            this.targetType(model.targetType);
            this.resourceTargetDetails(model.resourceTargetDetails);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(HookTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final ChangeSetHookResourceTargetDetails.Builder getResourceTargetDetails() {
            return this.resourceTargetDetails != null ? this.resourceTargetDetails.toBuilder() : null;
        }

        public final void setResourceTargetDetails(ChangeSetHookResourceTargetDetails.BuilderImpl resourceTargetDetails) {
            this.resourceTargetDetails = resourceTargetDetails != null ? resourceTargetDetails.build() : null;
        }

        @Override
        public final Builder resourceTargetDetails(ChangeSetHookResourceTargetDetails resourceTargetDetails) {
            this.resourceTargetDetails = resourceTargetDetails;
            return this;
        }

        public ChangeSetHookTargetDetails build() {
            return new ChangeSetHookTargetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSetHookTargetDetails> {
        public Builder targetType(String var1);

        public Builder targetType(HookTargetType var1);

        public Builder resourceTargetDetails(ChangeSetHookResourceTargetDetails var1);

        default public Builder resourceTargetDetails(Consumer<ChangeSetHookResourceTargetDetails.Builder> resourceTargetDetails) {
            return this.resourceTargetDetails((ChangeSetHookResourceTargetDetails)((ChangeSetHookResourceTargetDetails.Builder)ChangeSetHookResourceTargetDetails.builder().applyMutation(resourceTargetDetails)).build());
        }
    }
}

