/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.BeaconStackOperationStatus;
import software.amazon.awssdk.services.cloudformation.model.DetailedStatus;
import software.amazon.awssdk.services.cloudformation.model.EventType;
import software.amazon.awssdk.services.cloudformation.model.HookFailureMode;
import software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint;
import software.amazon.awssdk.services.cloudformation.model.HookStatus;
import software.amazon.awssdk.services.cloudformation.model.OperationType;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.services.cloudformation.model.ValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OperationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OperationEvent> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(OperationEvent.getter(OperationEvent::eventId)).setter(OperationEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(OperationEvent.getter(OperationEvent::stackId)).setter(OperationEvent.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(OperationEvent.getter(OperationEvent::operationId)).setter(OperationEvent.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(OperationEvent.getter(OperationEvent::operationTypeAsString)).setter(OperationEvent.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType").build()}).build();
    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationStatus").getter(OperationEvent.getter(OperationEvent::operationStatusAsString)).setter(OperationEvent.setter(Builder::operationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(OperationEvent.getter(OperationEvent::eventTypeAsString)).setter(OperationEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(OperationEvent.getter(OperationEvent::logicalResourceId)).setter(OperationEvent.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(OperationEvent.getter(OperationEvent::physicalResourceId)).setter(OperationEvent.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(OperationEvent.getter(OperationEvent::resourceType)).setter(OperationEvent.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(OperationEvent.getter(OperationEvent::timestamp)).setter(OperationEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(OperationEvent.getter(OperationEvent::startTime)).setter(OperationEvent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(OperationEvent.getter(OperationEvent::endTime)).setter(OperationEvent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(OperationEvent.getter(OperationEvent::resourceStatusAsString)).setter(OperationEvent.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatusReason").getter(OperationEvent.getter(OperationEvent::resourceStatusReason)).setter(OperationEvent.setter(Builder::resourceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build()}).build();
    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceProperties").getter(OperationEvent.getter(OperationEvent::resourceProperties)).setter(OperationEvent.setter(Builder::resourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(OperationEvent.getter(OperationEvent::clientRequestToken)).setter(OperationEvent.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> HOOK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookType").getter(OperationEvent.getter(OperationEvent::hookType)).setter(OperationEvent.setter(Builder::hookType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookType").build()}).build();
    private static final SdkField<String> HOOK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatus").getter(OperationEvent.getter(OperationEvent::hookStatusAsString)).setter(OperationEvent.setter(Builder::hookStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatus").build()}).build();
    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatusReason").getter(OperationEvent.getter(OperationEvent::hookStatusReason)).setter(OperationEvent.setter(Builder::hookStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()}).build();
    private static final SdkField<String> HOOK_INVOCATION_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookInvocationPoint").getter(OperationEvent.getter(OperationEvent::hookInvocationPointAsString)).setter(OperationEvent.setter(Builder::hookInvocationPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookInvocationPoint").build()}).build();
    private static final SdkField<String> HOOK_FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookFailureMode").getter(OperationEvent.getter(OperationEvent::hookFailureModeAsString)).setter(OperationEvent.setter(Builder::hookFailureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookFailureMode").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(OperationEvent.getter(OperationEvent::detailedStatusAsString)).setter(OperationEvent.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<String> VALIDATION_FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationFailureMode").getter(OperationEvent.getter(OperationEvent::validationFailureModeAsString)).setter(OperationEvent.setter(Builder::validationFailureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailureMode").build()}).build();
    private static final SdkField<String> VALIDATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationName").getter(OperationEvent.getter(OperationEvent::validationName)).setter(OperationEvent.setter(Builder::validationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationName").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(OperationEvent.getter(OperationEvent::validationStatusAsString)).setter(OperationEvent.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatusReason").getter(OperationEvent.getter(OperationEvent::validationStatusReason)).setter(OperationEvent.setter(Builder::validationStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusReason").build()}).build();
    private static final SdkField<String> VALIDATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationPath").getter(OperationEvent.getter(OperationEvent::validationPath)).setter(OperationEvent.setter(Builder::validationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, STACK_ID_FIELD, OPERATION_ID_FIELD, OPERATION_TYPE_FIELD, OPERATION_STATUS_FIELD, EVENT_TYPE_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TIMESTAMP_FIELD, START_TIME_FIELD, END_TIME_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, RESOURCE_PROPERTIES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, HOOK_TYPE_FIELD, HOOK_STATUS_FIELD, HOOK_STATUS_REASON_FIELD, HOOK_INVOCATION_POINT_FIELD, HOOK_FAILURE_MODE_FIELD, DETAILED_STATUS_FIELD, VALIDATION_FAILURE_MODE_FIELD, VALIDATION_NAME_FIELD, VALIDATION_STATUS_FIELD, VALIDATION_STATUS_REASON_FIELD, VALIDATION_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OperationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String stackId;
    private final String operationId;
    private final String operationType;
    private final String operationStatus;
    private final String eventType;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant timestamp;
    private final Instant startTime;
    private final Instant endTime;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String resourceProperties;
    private final String clientRequestToken;
    private final String hookType;
    private final String hookStatus;
    private final String hookStatusReason;
    private final String hookInvocationPoint;
    private final String hookFailureMode;
    private final String detailedStatus;
    private final String validationFailureMode;
    private final String validationName;
    private final String validationStatus;
    private final String validationStatusReason;
    private final String validationPath;

    private OperationEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.stackId = builder.stackId;
        this.operationId = builder.operationId;
        this.operationType = builder.operationType;
        this.operationStatus = builder.operationStatus;
        this.eventType = builder.eventType;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
        this.hookType = builder.hookType;
        this.hookStatus = builder.hookStatus;
        this.hookStatusReason = builder.hookStatusReason;
        this.hookInvocationPoint = builder.hookInvocationPoint;
        this.hookFailureMode = builder.hookFailureMode;
        this.detailedStatus = builder.detailedStatus;
        this.validationFailureMode = builder.validationFailureMode;
        this.validationName = builder.validationName;
        this.validationStatus = builder.validationStatus;
        this.validationStatusReason = builder.validationStatusReason;
        this.validationPath = builder.validationPath;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final BeaconStackOperationStatus operationStatus() {
        return BeaconStackOperationStatus.fromValue(this.operationStatus);
    }

    public final String operationStatusAsString() {
        return this.operationStatus;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public final String resourceProperties() {
        return this.resourceProperties;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String hookType() {
        return this.hookType;
    }

    public final HookStatus hookStatus() {
        return HookStatus.fromValue(this.hookStatus);
    }

    public final String hookStatusAsString() {
        return this.hookStatus;
    }

    public final String hookStatusReason() {
        return this.hookStatusReason;
    }

    public final HookInvocationPoint hookInvocationPoint() {
        return HookInvocationPoint.fromValue(this.hookInvocationPoint);
    }

    public final String hookInvocationPointAsString() {
        return this.hookInvocationPoint;
    }

    public final HookFailureMode hookFailureMode() {
        return HookFailureMode.fromValue(this.hookFailureMode);
    }

    public final String hookFailureModeAsString() {
        return this.hookFailureMode;
    }

    public final DetailedStatus detailedStatus() {
        return DetailedStatus.fromValue(this.detailedStatus);
    }

    public final String detailedStatusAsString() {
        return this.detailedStatus;
    }

    public final HookFailureMode validationFailureMode() {
        return HookFailureMode.fromValue(this.validationFailureMode);
    }

    public final String validationFailureModeAsString() {
        return this.validationFailureMode;
    }

    public final String validationName() {
        return this.validationName;
    }

    public final ValidationStatus validationStatus() {
        return ValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final String validationStatusReason() {
        return this.validationStatusReason;
    }

    public final String validationPath() {
        return this.validationPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookInvocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationFailureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationEvent)) {
            return false;
        }
        OperationEvent other = (OperationEvent)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.operationStatusAsString(), other.operationStatusAsString()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && Objects.equals(this.resourceProperties(), other.resourceProperties()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.hookType(), other.hookType()) && Objects.equals(this.hookStatusAsString(), other.hookStatusAsString()) && Objects.equals(this.hookStatusReason(), other.hookStatusReason()) && Objects.equals(this.hookInvocationPointAsString(), other.hookInvocationPointAsString()) && Objects.equals(this.hookFailureModeAsString(), other.hookFailureModeAsString()) && Objects.equals(this.detailedStatusAsString(), other.detailedStatusAsString()) && Objects.equals(this.validationFailureModeAsString(), other.validationFailureModeAsString()) && Objects.equals(this.validationName(), other.validationName()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.validationStatusReason(), other.validationStatusReason()) && Objects.equals(this.validationPath(), other.validationPath());
    }

    public final String toString() {
        return ToString.builder((String)"OperationEvent").add("EventId", (Object)this.eventId()).add("StackId", (Object)this.stackId()).add("OperationId", (Object)this.operationId()).add("OperationType", (Object)this.operationTypeAsString()).add("OperationStatus", (Object)this.operationStatusAsString()).add("EventType", (Object)this.eventTypeAsString()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Timestamp", (Object)this.timestamp()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("ResourceProperties", (Object)this.resourceProperties()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("HookType", (Object)this.hookType()).add("HookStatus", (Object)this.hookStatusAsString()).add("HookStatusReason", (Object)this.hookStatusReason()).add("HookInvocationPoint", (Object)this.hookInvocationPointAsString()).add("HookFailureMode", (Object)this.hookFailureModeAsString()).add("DetailedStatus", (Object)this.detailedStatusAsString()).add("ValidationFailureMode", (Object)this.validationFailureModeAsString()).add("ValidationName", (Object)this.validationName()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("ValidationStatusReason", (Object)this.validationStatusReason()).add("ValidationPath", (Object)this.validationPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "OperationStatus": {
                return Optional.ofNullable(clazz.cast(this.operationStatusAsString()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusReason()));
            }
            case "ResourceProperties": {
                return Optional.ofNullable(clazz.cast(this.resourceProperties()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "HookType": {
                return Optional.ofNullable(clazz.cast(this.hookType()));
            }
            case "HookStatus": {
                return Optional.ofNullable(clazz.cast(this.hookStatusAsString()));
            }
            case "HookStatusReason": {
                return Optional.ofNullable(clazz.cast(this.hookStatusReason()));
            }
            case "HookInvocationPoint": {
                return Optional.ofNullable(clazz.cast(this.hookInvocationPointAsString()));
            }
            case "HookFailureMode": {
                return Optional.ofNullable(clazz.cast(this.hookFailureModeAsString()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatusAsString()));
            }
            case "ValidationFailureMode": {
                return Optional.ofNullable(clazz.cast(this.validationFailureModeAsString()));
            }
            case "ValidationName": {
                return Optional.ofNullable(clazz.cast(this.validationName()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "ValidationStatusReason": {
                return Optional.ofNullable(clazz.cast(this.validationStatusReason()));
            }
            case "ValidationPath": {
                return Optional.ofNullable(clazz.cast(this.validationPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventId", EVENT_ID_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("OperationType", OPERATION_TYPE_FIELD);
        map.put("OperationStatus", OPERATION_STATUS_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("ResourceStatus", RESOURCE_STATUS_FIELD);
        map.put("ResourceStatusReason", RESOURCE_STATUS_REASON_FIELD);
        map.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("HookType", HOOK_TYPE_FIELD);
        map.put("HookStatus", HOOK_STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("HookInvocationPoint", HOOK_INVOCATION_POINT_FIELD);
        map.put("HookFailureMode", HOOK_FAILURE_MODE_FIELD);
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        map.put("ValidationFailureMode", VALIDATION_FAILURE_MODE_FIELD);
        map.put("ValidationName", VALIDATION_NAME_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        map.put("ValidationStatusReason", VALIDATION_STATUS_REASON_FIELD);
        map.put("ValidationPath", VALIDATION_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationEvent, T> g) {
        return obj -> g.apply((OperationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String stackId;
        private String operationId;
        private String operationType;
        private String operationStatus;
        private String eventType;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant timestamp;
        private Instant startTime;
        private Instant endTime;
        private String resourceStatus;
        private String resourceStatusReason;
        private String resourceProperties;
        private String clientRequestToken;
        private String hookType;
        private String hookStatus;
        private String hookStatusReason;
        private String hookInvocationPoint;
        private String hookFailureMode;
        private String detailedStatus;
        private String validationFailureMode;
        private String validationName;
        private String validationStatus;
        private String validationStatusReason;
        private String validationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationEvent model) {
            this.eventId(model.eventId);
            this.stackId(model.stackId);
            this.operationId(model.operationId);
            this.operationType(model.operationType);
            this.operationStatus(model.operationStatus);
            this.eventType(model.eventType);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.timestamp(model.timestamp);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.resourceProperties(model.resourceProperties);
            this.clientRequestToken(model.clientRequestToken);
            this.hookType(model.hookType);
            this.hookStatus(model.hookStatus);
            this.hookStatusReason(model.hookStatusReason);
            this.hookInvocationPoint(model.hookInvocationPoint);
            this.hookFailureMode(model.hookFailureMode);
            this.detailedStatus(model.detailedStatus);
            this.validationFailureMode(model.validationFailureMode);
            this.validationName(model.validationName);
            this.validationStatus(model.validationStatus);
            this.validationStatusReason(model.validationStatusReason);
            this.validationPath(model.validationPath);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getOperationStatus() {
            return this.operationStatus;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(BeaconStackOperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getHookType() {
            return this.hookType;
        }

        public final void setHookType(String hookType) {
            this.hookType = hookType;
        }

        @Override
        public final Builder hookType(String hookType) {
            this.hookType = hookType;
            return this;
        }

        public final String getHookStatus() {
            return this.hookStatus;
        }

        public final void setHookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
        }

        @Override
        public final Builder hookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        @Override
        public final Builder hookStatus(HookStatus hookStatus) {
            this.hookStatus(hookStatus == null ? null : hookStatus.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return this.hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final String getHookInvocationPoint() {
            return this.hookInvocationPoint;
        }

        public final void setHookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
        }

        @Override
        public final Builder hookInvocationPoint(String hookInvocationPoint) {
            this.hookInvocationPoint = hookInvocationPoint;
            return this;
        }

        @Override
        public final Builder hookInvocationPoint(HookInvocationPoint hookInvocationPoint) {
            this.hookInvocationPoint(hookInvocationPoint == null ? null : hookInvocationPoint.toString());
            return this;
        }

        public final String getHookFailureMode() {
            return this.hookFailureMode;
        }

        public final void setHookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
        }

        @Override
        public final Builder hookFailureMode(String hookFailureMode) {
            this.hookFailureMode = hookFailureMode;
            return this;
        }

        @Override
        public final Builder hookFailureMode(HookFailureMode hookFailureMode) {
            this.hookFailureMode(hookFailureMode == null ? null : hookFailureMode.toString());
            return this;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(DetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        public final String getValidationFailureMode() {
            return this.validationFailureMode;
        }

        public final void setValidationFailureMode(String validationFailureMode) {
            this.validationFailureMode = validationFailureMode;
        }

        @Override
        public final Builder validationFailureMode(String validationFailureMode) {
            this.validationFailureMode = validationFailureMode;
            return this;
        }

        @Override
        public final Builder validationFailureMode(HookFailureMode validationFailureMode) {
            this.validationFailureMode(validationFailureMode == null ? null : validationFailureMode.toString());
            return this;
        }

        public final String getValidationName() {
            return this.validationName;
        }

        public final void setValidationName(String validationName) {
            this.validationName = validationName;
        }

        @Override
        public final Builder validationName(String validationName) {
            this.validationName = validationName;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(ValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusReason() {
            return this.validationStatusReason;
        }

        public final void setValidationStatusReason(String validationStatusReason) {
            this.validationStatusReason = validationStatusReason;
        }

        @Override
        public final Builder validationStatusReason(String validationStatusReason) {
            this.validationStatusReason = validationStatusReason;
            return this;
        }

        public final String getValidationPath() {
            return this.validationPath;
        }

        public final void setValidationPath(String validationPath) {
            this.validationPath = validationPath;
        }

        @Override
        public final Builder validationPath(String validationPath) {
            this.validationPath = validationPath;
            return this;
        }

        public OperationEvent build() {
            return new OperationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OperationEvent> {
        public Builder eventId(String var1);

        public Builder stackId(String var1);

        public Builder operationId(String var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder operationStatus(String var1);

        public Builder operationStatus(BeaconStackOperationStatus var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder timestamp(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder resourceProperties(String var1);

        public Builder clientRequestToken(String var1);

        public Builder hookType(String var1);

        public Builder hookStatus(String var1);

        public Builder hookStatus(HookStatus var1);

        public Builder hookStatusReason(String var1);

        public Builder hookInvocationPoint(String var1);

        public Builder hookInvocationPoint(HookInvocationPoint var1);

        public Builder hookFailureMode(String var1);

        public Builder hookFailureMode(HookFailureMode var1);

        public Builder detailedStatus(String var1);

        public Builder detailedStatus(DetailedStatus var1);

        public Builder validationFailureMode(String var1);

        public Builder validationFailureMode(HookFailureMode var1);

        public Builder validationName(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(ValidationStatus var1);

        public Builder validationStatusReason(String var1);

        public Builder validationPath(String var1);
    }
}

