/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary;

public class ListStackRefactorsIterable
implements SdkIterable<ListStackRefactorsResponse> {
    private final CloudFormationClient client;
    private final ListStackRefactorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackRefactorsIterable(CloudFormationClient client, ListStackRefactorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStackRefactorsResponseFetcher();
    }

    public Iterator<ListStackRefactorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackRefactorSummary> stackRefactorSummaries() {
        Function<ListStackRefactorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackRefactorSummaries() != null) {
                return response.stackRefactorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackRefactorsResponseFetcher
    implements SyncPageFetcher<ListStackRefactorsResponse> {
        private ListStackRefactorsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackRefactorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackRefactorsResponse nextPage(ListStackRefactorsResponse previousPage) {
            if (previousPage == null) {
                return ListStackRefactorsIterable.this.client.listStackRefactors(ListStackRefactorsIterable.this.firstRequest);
            }
            return ListStackRefactorsIterable.this.client.listStackRefactors((ListStackRefactorsRequest)((Object)ListStackRefactorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

