/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.RegistrationStatus;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypeRegistrationsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListTypeRegistrationsRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::typeAsString)).setter(ListTypeRegistrationsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::typeName)).setter(ListTypeRegistrationsRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::typeArn)).setter(ListTypeRegistrationsRequest.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationStatusFilter").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::registrationStatusFilterAsString)).setter(ListTypeRegistrationsRequest.setter(Builder::registrationStatusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationStatusFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::maxResults)).setter(ListTypeRegistrationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTypeRegistrationsRequest.getter(ListTypeRegistrationsRequest::nextToken)).setter(ListTypeRegistrationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, TYPE_ARN_FIELD, REGISTRATION_STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("TypeArn", TYPE_ARN_FIELD);
            this.put("RegistrationStatusFilter", REGISTRATION_STATUS_FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String type;
    private final String typeName;
    private final String typeArn;
    private final String registrationStatusFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListTypeRegistrationsRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.typeArn = builder.typeArn;
        this.registrationStatusFilter = builder.registrationStatusFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final RegistrationStatus registrationStatusFilter() {
        return RegistrationStatus.fromValue(this.registrationStatusFilter);
    }

    public final String registrationStatusFilterAsString() {
        return this.registrationStatusFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeRegistrationsRequest)) {
            return false;
        }
        ListTypeRegistrationsRequest other = (ListTypeRegistrationsRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.registrationStatusFilterAsString(), other.registrationStatusFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTypeRegistrationsRequest").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("TypeArn", (Object)this.typeArn()).add("RegistrationStatusFilter", (Object)this.registrationStatusFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "RegistrationStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusFilterAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeRegistrationsRequest, T> g) {
        return obj -> g.apply((ListTypeRegistrationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String typeArn;
        private String registrationStatusFilter;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeRegistrationsRequest model) {
            super(model);
            this.type(model.type);
            this.typeName(model.typeName);
            this.typeArn(model.typeArn);
            this.registrationStatusFilter(model.registrationStatusFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getRegistrationStatusFilter() {
            return this.registrationStatusFilter;
        }

        public final void setRegistrationStatusFilter(String registrationStatusFilter) {
            this.registrationStatusFilter = registrationStatusFilter;
        }

        @Override
        public final Builder registrationStatusFilter(String registrationStatusFilter) {
            this.registrationStatusFilter = registrationStatusFilter;
            return this;
        }

        @Override
        public final Builder registrationStatusFilter(RegistrationStatus registrationStatusFilter) {
            this.registrationStatusFilter(registrationStatusFilter == null ? null : registrationStatusFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypeRegistrationsRequest build() {
            return new ListTypeRegistrationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypeRegistrationsRequest> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder typeArn(String var1);

        public Builder registrationStatusFilter(String var1);

        public Builder registrationStatusFilter(RegistrationStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

