/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StageListCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(GetTemplateResponse.getter(GetTemplateResponse::templateBody)).setter(GetTemplateResponse.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<List<String>> STAGES_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StagesAvailable").getter(GetTemplateResponse.getter(GetTemplateResponse::stagesAvailableAsStrings)).setter(GetTemplateResponse.setter(Builder::stagesAvailableWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagesAvailable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD, STAGES_AVAILABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TemplateBody", TEMPLATE_BODY_FIELD);
            this.put("StagesAvailable", STAGES_AVAILABLE_FIELD);
        }
    });
    private final String templateBody;
    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final List<TemplateStage> stagesAvailable() {
        return StageListCopier.copyStringToEnum(this.stagesAvailable);
    }

    public final boolean hasStagesAvailable() {
        return this.stagesAvailable != null && !(this.stagesAvailable instanceof SdkAutoConstructList);
    }

    public final List<String> stagesAvailableAsStrings() {
        return this.stagesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStagesAvailable() ? this.stagesAvailableAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && this.hasStagesAvailable() == other.hasStagesAvailable() && Objects.equals(this.stagesAvailableAsStrings(), other.stagesAvailableAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("TemplateBody", (Object)this.templateBody()).add("StagesAvailable", this.hasStagesAvailable() ? this.stagesAvailableAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "StagesAvailable": {
                return Optional.ofNullable(clazz.cast(this.stagesAvailableAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String templateBody;
        private List<String> stagesAvailable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.templateBody(model.templateBody);
            this.stagesAvailableWithStrings(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final Collection<String> getStagesAvailable() {
            if (this.stagesAvailable instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stagesAvailable;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public final Builder stagesAvailableWithStrings(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailableWithStrings(String ... stagesAvailable) {
            this.stagesAvailableWithStrings(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public final Builder stagesAvailable(Collection<TemplateStage> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copyEnumToString(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(TemplateStage ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder templateBody(String var1);

        public Builder stagesAvailableWithStrings(Collection<String> var1);

        public Builder stagesAvailableWithStrings(String ... var1);

        public Builder stagesAvailable(Collection<TemplateStage> var1);

        public Builder stagesAvailable(TemplateStage ... var1);
    }
}

