/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.LogicalResourceIdsCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdentifierSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceIdentifierSummary> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceIdentifierSummary.getter(ResourceIdentifierSummary::resourceType)).setter(ResourceIdentifierSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> LOGICAL_RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogicalResourceIds").getter(ResourceIdentifierSummary.getter(ResourceIdentifierSummary::logicalResourceIds)).setter(ResourceIdentifierSummary.setter(Builder::logicalResourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifiers").getter(ResourceIdentifierSummary.getter(ResourceIdentifierSummary::resourceIdentifiers)).setter(ResourceIdentifierSummary.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, LOGICAL_RESOURCE_IDS_FIELD, RESOURCE_IDENTIFIERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final List<String> logicalResourceIds;
    private final List<String> resourceIdentifiers;

    private ResourceIdentifierSummary(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.logicalResourceIds = builder.logicalResourceIds;
        this.resourceIdentifiers = builder.resourceIdentifiers;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasLogicalResourceIds() {
        return this.logicalResourceIds != null && !(this.logicalResourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> logicalResourceIds() {
        return this.logicalResourceIds;
    }

    public final boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalResourceIds() ? this.logicalResourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifierSummary)) {
            return false;
        }
        ResourceIdentifierSummary other = (ResourceIdentifierSummary)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && this.hasLogicalResourceIds() == other.hasLogicalResourceIds() && Objects.equals(this.logicalResourceIds(), other.logicalResourceIds()) && this.hasResourceIdentifiers() == other.hasResourceIdentifiers() && Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceIdentifierSummary").add("ResourceType", (Object)this.resourceType()).add("LogicalResourceIds", this.hasLogicalResourceIds() ? this.logicalResourceIds() : null).add("ResourceIdentifiers", this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LogicalResourceIds": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceIds()));
            }
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifierSummary, T> g) {
        return obj -> g.apply((ResourceIdentifierSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<String> logicalResourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifierSummary model) {
            this.resourceType(model.resourceType);
            this.logicalResourceIds(model.logicalResourceIds);
            this.resourceIdentifiers(model.resourceIdentifiers);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Collection<String> getLogicalResourceIds() {
            if (this.logicalResourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logicalResourceIds;
        }

        public final void setLogicalResourceIds(Collection<String> logicalResourceIds) {
            this.logicalResourceIds = LogicalResourceIdsCopier.copy(logicalResourceIds);
        }

        @Override
        public final Builder logicalResourceIds(Collection<String> logicalResourceIds) {
            this.logicalResourceIds = LogicalResourceIdsCopier.copy(logicalResourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logicalResourceIds(String ... logicalResourceIds) {
            this.logicalResourceIds(Arrays.asList(logicalResourceIds));
            return this;
        }

        public final Collection<String> getResourceIdentifiers() {
            if (this.resourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIdentifiers;
        }

        public final void setResourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(String ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        public ResourceIdentifierSummary build() {
            return new ResourceIdentifierSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceIdentifierSummary> {
        public Builder resourceType(String var1);

        public Builder logicalResourceIds(Collection<String> var1);

        public Builder logicalResourceIds(String ... var1);

        public Builder resourceIdentifiers(Collection<String> var1);

        public Builder resourceIdentifiers(String ... var1);
    }
}

