/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;

public class ListTypeVersionsIterable
implements SdkIterable<ListTypeVersionsResponse> {
    private final CloudFormationClient client;
    private final ListTypeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypeVersionsIterable(CloudFormationClient client, ListTypeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTypeVersionsResponseFetcher();
    }

    public Iterator<ListTypeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTypeVersionsResponseFetcher
    implements SyncPageFetcher<ListTypeVersionsResponse> {
        private ListTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTypeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypeVersionsResponse nextPage(ListTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTypeVersionsIterable.this.client.listTypeVersions(ListTypeVersionsIterable.this.firstRequest);
            }
            return ListTypeVersionsIterable.this.client.listTypeVersions((ListTypeVersionsRequest)((Object)ListTypeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

