/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CallAs {
    SELF("SELF"),
    DELEGATED_ADMIN("DELEGATED_ADMIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CallAs> VALUE_MAP;
    private final String value;

    private CallAs(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CallAs fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CallAs> knownValues() {
        EnumSet<CallAs> knownValues = EnumSet.allOf(CallAs.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CallAs.class, CallAs::toString);
    }
}

