/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_FAILED("CREATE_FAILED"),
    CREATE_COMPLETE("CREATE_COMPLETE"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_FAILED("DELETE_FAILED"),
    DELETE_COMPLETE("DELETE_COMPLETE"),
    DELETE_SKIPPED("DELETE_SKIPPED"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UPDATE_COMPLETE("UPDATE_COMPLETE"),
    IMPORT_FAILED("IMPORT_FAILED"),
    IMPORT_COMPLETE("IMPORT_COMPLETE"),
    IMPORT_IN_PROGRESS("IMPORT_IN_PROGRESS"),
    IMPORT_ROLLBACK_IN_PROGRESS("IMPORT_ROLLBACK_IN_PROGRESS"),
    IMPORT_ROLLBACK_FAILED("IMPORT_ROLLBACK_FAILED"),
    IMPORT_ROLLBACK_COMPLETE("IMPORT_ROLLBACK_COMPLETE"),
    UPDATE_ROLLBACK_IN_PROGRESS("UPDATE_ROLLBACK_IN_PROGRESS"),
    UPDATE_ROLLBACK_COMPLETE("UPDATE_ROLLBACK_COMPLETE"),
    UPDATE_ROLLBACK_FAILED("UPDATE_ROLLBACK_FAILED"),
    ROLLBACK_IN_PROGRESS("ROLLBACK_IN_PROGRESS"),
    ROLLBACK_COMPLETE("ROLLBACK_COMPLETE"),
    ROLLBACK_FAILED("ROLLBACK_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceStatus> VALUE_MAP;
    private final String value;

    private ResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceStatus> knownValues() {
        EnumSet<ResourceStatus> knownValues = EnumSet.allOf(ResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceStatus.class, ResourceStatus::toString);
    }
}

