/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackSetOperationResultsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListStackSetOperationResultsRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(ListStackSetOperationResultsRequest.getter(ListStackSetOperationResultsRequest::stackSetName)).setter(ListStackSetOperationResultsRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(ListStackSetOperationResultsRequest.getter(ListStackSetOperationResultsRequest::operationId)).setter(ListStackSetOperationResultsRequest.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStackSetOperationResultsRequest.getter(ListStackSetOperationResultsRequest::nextToken)).setter(ListStackSetOperationResultsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListStackSetOperationResultsRequest.getter(ListStackSetOperationResultsRequest::maxResults)).setter(ListStackSetOperationResultsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(ListStackSetOperationResultsRequest.getter(ListStackSetOperationResultsRequest::callAsAsString)).setter(ListStackSetOperationResultsRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, OPERATION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CALL_AS_FIELD));
    private final String stackSetName;
    private final String operationId;
    private final String nextToken;
    private final Integer maxResults;
    private final String callAs;

    private ListStackSetOperationResultsRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.callAs = builder.callAs;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationResultsRequest)) {
            return false;
        }
        ListStackSetOperationResultsRequest other = (ListStackSetOperationResultsRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.callAsAsString(), other.callAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackSetOperationResultsRequest").add("StackSetName", (Object)this.stackSetName()).add("OperationId", (Object)this.operationId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("CallAs", (Object)this.callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackSetOperationResultsRequest, T> g) {
        return obj -> g.apply((ListStackSetOperationResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private String operationId;
        private String nextToken;
        private Integer maxResults;
        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationResultsRequest model) {
            super(model);
            this.stackSetName(model.stackSetName);
            this.operationId(model.operationId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.callAs(model.callAs);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        @Transient
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        @Transient
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        @Transient
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        @Transient
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackSetOperationResultsRequest build() {
            return new ListStackSetOperationResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackSetOperationResultsRequest> {
        public Builder stackSetName(String var1);

        public Builder operationId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

