/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.AccountLimit;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;

public class DescribeAccountLimitsIterable
implements SdkIterable<DescribeAccountLimitsResponse> {
    private final CloudFormationClient client;
    private final DescribeAccountLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAccountLimitsIterable(CloudFormationClient client, DescribeAccountLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAccountLimitsResponseFetcher();
    }

    public Iterator<DescribeAccountLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountLimit> accountLimits() {
        Function<DescribeAccountLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountLimits() != null) {
                return response.accountLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAccountLimitsResponseFetcher
    implements SyncPageFetcher<DescribeAccountLimitsResponse> {
        private DescribeAccountLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAccountLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAccountLimitsResponse nextPage(DescribeAccountLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAccountLimitsIterable.this.client.describeAccountLimits(DescribeAccountLimitsIterable.this.firstRequest);
            }
            return DescribeAccountLimitsIterable.this.client.describeAccountLimits((DescribeAccountLimitsRequest)((Object)DescribeAccountLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

