/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a specific version of a CloudFormation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TypeVersionSummary.Builder, TypeVersionSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TypeVersionSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeVersionSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(TypeVersionSummary::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultVersion").getter(getter(TypeVersionSummary::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TypeVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeCreated").getter(getter(TypeVersionSummary::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TypeVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, ARN_FIELD, TIME_CREATED_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String typeName;

    private final String versionId;

    private final Boolean isDefaultVersion;

    private final String arn;

    private final Instant timeCreated;

    private final String description;

    private TypeVersionSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.arn = builder.arn;
        this.timeCreated = builder.timeCreated;
        this.description = builder.description;
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * 
     * @return The name of the type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name
     * (ARN) assigned to the type version when it is registered.
     * </p>
     * 
     * @return The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource
     *         Name (ARN) assigned to the type version when it is registered.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Whether the specified type version is set as the default version.
     * </p>
     * 
     * @return Whether the specified type version is set as the default version.
     */
    public final Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the version was registered.
     * </p>
     * 
     * @return When the version was registered.
     */
    public final Instant timeCreated() {
        return timeCreated;
    }

    /**
     * <p>
     * The description of the type version.
     * </p>
     * 
     * @return The description of the type version.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeVersionSummary)) {
            return false;
        }
        TypeVersionSummary other = (TypeVersionSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(isDefaultVersion(), other.isDefaultVersion())
                && Objects.equals(arn(), other.arn()) && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeVersionSummary").add("Type", typeAsString()).add("TypeName", typeName())
                .add("VersionId", versionId()).add("IsDefaultVersion", isDefaultVersion()).add("Arn", arn())
                .add("TimeCreated", timeCreated()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "IsDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TimeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeVersionSummary, T> g) {
        return obj -> g.apply((TypeVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeVersionSummary> {
        /**
         * <p>
         * The kind of type.
         * </p>
         * 
         * @param type
         *        The kind of type.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of type.
         * </p>
         * 
         * @param type
         *        The kind of type.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the type.
         * </p>
         * 
         * @param typeName
         *        The name of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name
         * (ARN) assigned to the type version when it is registered.
         * </p>
         * 
         * @param versionId
         *        The ID of a specific version of the type. The version ID is the value at the end of the Amazon
         *        Resource Name (ARN) assigned to the type version when it is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Whether the specified type version is set as the default version.
         * </p>
         * 
         * @param isDefaultVersion
         *        Whether the specified type version is set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the version was registered.
         * </p>
         * 
         * @param timeCreated
         *        When the version was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(Instant timeCreated);

        /**
         * <p>
         * The description of the type version.
         * </p>
         * 
         * @param description
         *        The description of the type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String versionId;

        private Boolean isDefaultVersion;

        private String arn;

        private Instant timeCreated;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeVersionSummary model) {
            type(model.type);
            typeName(model.typeName);
            versionId(model.versionId);
            isDefaultVersion(model.isDefaultVersion);
            arn(model.arn);
            timeCreated(model.timeCreated);
            description(model.description);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TypeVersionSummary build() {
            return new TypeVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
