/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoDeployment> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AutoDeployment.getter(AutoDeployment::enabled)).setter(AutoDeployment.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> RETAIN_STACKS_ON_ACCOUNT_REMOVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetainStacksOnAccountRemoval").getter(AutoDeployment.getter(AutoDeployment::retainStacksOnAccountRemoval)).setter(AutoDeployment.setter(Builder::retainStacksOnAccountRemoval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainStacksOnAccountRemoval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, RETAIN_STACKS_ON_ACCOUNT_REMOVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean retainStacksOnAccountRemoval;

    private AutoDeployment(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.retainStacksOnAccountRemoval = builder.retainStacksOnAccountRemoval;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean retainStacksOnAccountRemoval() {
        return this.retainStacksOnAccountRemoval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainStacksOnAccountRemoval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDeployment)) {
            return false;
        }
        AutoDeployment other = (AutoDeployment)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.retainStacksOnAccountRemoval(), other.retainStacksOnAccountRemoval());
    }

    public String toString() {
        return ToString.builder((String)"AutoDeployment").add("Enabled", (Object)this.enabled()).add("RetainStacksOnAccountRemoval", (Object)this.retainStacksOnAccountRemoval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "RetainStacksOnAccountRemoval": {
                return Optional.ofNullable(clazz.cast(this.retainStacksOnAccountRemoval()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoDeployment, T> g) {
        return obj -> g.apply((AutoDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean retainStacksOnAccountRemoval;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoDeployment model) {
            this.enabled(model.enabled);
            this.retainStacksOnAccountRemoval(model.retainStacksOnAccountRemoval);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getRetainStacksOnAccountRemoval() {
            return this.retainStacksOnAccountRemoval;
        }

        @Override
        public final Builder retainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
            this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
            return this;
        }

        public final void setRetainStacksOnAccountRemoval(Boolean retainStacksOnAccountRemoval) {
            this.retainStacksOnAccountRemoval = retainStacksOnAccountRemoval;
        }

        public AutoDeployment build() {
            return new AutoDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoDeployment> {
        public Builder enabled(Boolean var1);

        public Builder retainStacksOnAccountRemoval(Boolean var1);
    }
}

