/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypeSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypeSummary.getter(TypeSummary::typeAsString)).setter(TypeSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypeSummary.getter(TypeSummary::typeName)).setter(TypeSummary.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypeSummary.getter(TypeSummary::defaultVersionId)).setter(TypeSummary.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypeSummary.getter(TypeSummary::typeArn)).setter(TypeSummary.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TypeSummary.getter(TypeSummary::lastUpdated)).setter(TypeSummary.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypeSummary.getter(TypeSummary::description)).setter(TypeSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, TYPE_ARN_FIELD, LAST_UPDATED_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String typeName;
    private final String defaultVersionId;
    private final String typeArn;
    private final Instant lastUpdated;
    private final String description;

    private TypeSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.typeArn = builder.typeArn;
        this.lastUpdated = builder.lastUpdated;
        this.description = builder.description;
    }

    public RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public String typeArn() {
        return this.typeArn;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSummary)) {
            return false;
        }
        TypeSummary other = (TypeSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"TypeSummary").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("TypeArn", (Object)this.typeArn()).add("LastUpdated", (Object)this.lastUpdated()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeSummary, T> g) {
        return obj -> g.apply((TypeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String defaultVersionId;
        private String typeArn;
        private Instant lastUpdated;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeSummary model) {
            this.type(model.type);
            this.typeName(model.typeName);
            this.defaultVersionId(model.defaultVersionId);
            this.typeArn(model.typeArn);
            this.lastUpdated(model.lastUpdated);
            this.description(model.description);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public TypeSummary build() {
            return new TypeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypeSummary> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder defaultVersionId(String var1);

        public Builder typeArn(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder description(String var1);
    }
}

