/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.OutputsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.StackDriftInformation;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stack> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::stackId)).setter(Stack.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::stackName)).setter(Stack.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::changeSetId)).setter(Stack.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::description)).setter(Stack.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Stack.getter(Stack::parameters)).setter(Stack.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Stack.getter(Stack::creationTime)).setter(Stack.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Stack.getter(Stack::deletionTime)).setter(Stack.setter(Builder::deletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Stack.getter(Stack::lastUpdatedTime)).setter(Stack.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stack.getter(Stack::rollbackConfiguration)).setter(Stack.setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build()}).build();
    private static final SdkField<String> STACK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::stackStatusAsString)).setter(Stack.setter(Builder::stackStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatus").build()}).build();
    private static final SdkField<String> STACK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::stackStatusReason)).setter(Stack.setter(Builder::stackStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusReason").build()}).build();
    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stack.getter(Stack::disableRollback)).setter(Stack.setter(Builder::disableRollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Stack.getter(Stack::notificationARNs)).setter(Stack.setter(Builder::notificationARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Stack.getter(Stack::timeoutInMinutes)).setter(Stack.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Stack.getter(Stack::capabilitiesAsStrings)).setter(Stack.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Stack.getter(Stack::outputs)).setter(Stack.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::roleARN)).setter(Stack.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Stack.getter(Stack::tags)).setter(Stack.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Stack.getter(Stack::enableTerminationProtection)).setter(Stack.setter(Builder::enableTerminationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::parentId)).setter(Stack.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> ROOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Stack.getter(Stack::rootId)).setter(Stack.setter(Builder::rootId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()}).build();
    private static final SdkField<StackDriftInformation> DRIFT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Stack.getter(Stack::driftInformation)).setter(Stack.setter(Builder::driftInformation)).constructor(StackDriftInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, STACK_NAME_FIELD, CHANGE_SET_ID_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, CREATION_TIME_FIELD, DELETION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, ROLLBACK_CONFIGURATION_FIELD, STACK_STATUS_FIELD, STACK_STATUS_REASON_FIELD, DISABLE_ROLLBACK_FIELD, NOTIFICATION_AR_NS_FIELD, TIMEOUT_IN_MINUTES_FIELD, CAPABILITIES_FIELD, OUTPUTS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, ENABLE_TERMINATION_PROTECTION_FIELD, PARENT_ID_FIELD, ROOT_ID_FIELD, DRIFT_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String description;
    private final List<Parameter> parameters;
    private final Instant creationTime;
    private final Instant deletionTime;
    private final Instant lastUpdatedTime;
    private final RollbackConfiguration rollbackConfiguration;
    private final String stackStatus;
    private final String stackStatusReason;
    private final Boolean disableRollback;
    private final List<String> notificationARNs;
    private final Integer timeoutInMinutes;
    private final List<String> capabilities;
    private final List<Output> outputs;
    private final String roleARN;
    private final List<Tag> tags;
    private final Boolean enableTerminationProtection;
    private final String parentId;
    private final String rootId;
    private final StackDriftInformation driftInformation;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.deletionTime = builder.deletionTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.disableRollback = builder.disableRollback;
        this.notificationARNs = builder.notificationARNs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.capabilities = builder.capabilities;
        this.outputs = builder.outputs;
        this.roleARN = builder.roleARN;
        this.tags = builder.tags;
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.parentId = builder.parentId;
        this.rootId = builder.rootId;
        this.driftInformation = builder.driftInformation;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String description() {
        return this.description;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant deletionTime() {
        return this.deletionTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public StackStatus stackStatus() {
        return StackStatus.fromValue(this.stackStatus);
    }

    public String stackStatusAsString() {
        return this.stackStatus;
    }

    public String stackStatusReason() {
        return this.stackStatusReason;
    }

    public Boolean disableRollback() {
        return this.disableRollback;
    }

    public boolean hasNotificationARNs() {
        return this.notificationARNs != null && !(this.notificationARNs instanceof SdkAutoConstructList);
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean enableTerminationProtection() {
        return this.enableTerminationProtection;
    }

    public String parentId() {
        return this.parentId;
    }

    public String rootId() {
        return this.rootId;
    }

    public StackDriftInformation driftInformation() {
        return this.driftInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootId());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftInformation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deletionTime(), other.deletionTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && Objects.equals(this.stackStatusAsString(), other.stackStatusAsString()) && Objects.equals(this.stackStatusReason(), other.stackStatusReason()) && Objects.equals(this.disableRollback(), other.disableRollback()) && Objects.equals(this.notificationARNs(), other.notificationARNs()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableTerminationProtection(), other.enableTerminationProtection()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.rootId(), other.rootId()) && Objects.equals(this.driftInformation(), other.driftInformation());
    }

    public String toString() {
        return ToString.builder((String)"Stack").add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).add("ChangeSetId", (Object)this.changeSetId()).add("Description", (Object)this.description()).add("Parameters", this.parameters()).add("CreationTime", (Object)this.creationTime()).add("DeletionTime", (Object)this.deletionTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("RollbackConfiguration", (Object)this.rollbackConfiguration()).add("StackStatus", (Object)this.stackStatusAsString()).add("StackStatusReason", (Object)this.stackStatusReason()).add("DisableRollback", (Object)this.disableRollback()).add("NotificationARNs", this.notificationARNs()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("Capabilities", this.capabilitiesAsStrings()).add("Outputs", this.outputs()).add("RoleARN", (Object)this.roleARN()).add("Tags", this.tags()).add("EnableTerminationProtection", (Object)this.enableTerminationProtection()).add("ParentId", (Object)this.parentId()).add("RootId", (Object)this.rootId()).add("DriftInformation", (Object)this.driftInformation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DeletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "RollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rollbackConfiguration()));
            }
            case "StackStatus": {
                return Optional.ofNullable(clazz.cast(this.stackStatusAsString()));
            }
            case "StackStatusReason": {
                return Optional.ofNullable(clazz.cast(this.stackStatusReason()));
            }
            case "DisableRollback": {
                return Optional.ofNullable(clazz.cast(this.disableRollback()));
            }
            case "NotificationARNs": {
                return Optional.ofNullable(clazz.cast(this.notificationARNs()));
            }
            case "TimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EnableTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.enableTerminationProtection()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "RootId": {
                return Optional.ofNullable(clazz.cast(this.rootId()));
            }
            case "DriftInformation": {
                return Optional.ofNullable(clazz.cast(this.driftInformation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stack, T> g) {
        return obj -> g.apply((Stack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String description;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant deletionTime;
        private Instant lastUpdatedTime;
        private RollbackConfiguration rollbackConfiguration;
        private String stackStatus;
        private String stackStatusReason;
        private Boolean disableRollback;
        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();
        private Integer timeoutInMinutes;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableTerminationProtection;
        private String parentId;
        private String rootId;
        private StackDriftInformation driftInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.changeSetId(model.changeSetId);
            this.description(model.description);
            this.parameters(model.parameters);
            this.creationTime(model.creationTime);
            this.deletionTime(model.deletionTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.stackStatus(model.stackStatus);
            this.stackStatusReason(model.stackStatusReason);
            this.disableRollback(model.disableRollback);
            this.notificationARNs(model.notificationARNs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.capabilitiesWithStrings(model.capabilities);
            this.outputs(model.outputs);
            this.roleARN(model.roleARN);
            this.tags(model.tags);
            this.enableTerminationProtection(model.enableTerminationProtection);
            this.parentId(model.parentId);
            this.rootId(model.rootId);
            this.driftInformation(model.driftInformation);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getDeletionTime() {
            return this.deletionTime;
        }

        @Override
        public final Builder deletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final void setDeletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus == null ? null : stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final Boolean getDisableRollback() {
            return this.disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableTerminationProtection() {
            return this.enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getRootId() {
            return this.rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public final StackDriftInformation.Builder getDriftInformation() {
            return this.driftInformation != null ? this.driftInformation.toBuilder() : null;
        }

        @Override
        public final Builder driftInformation(StackDriftInformation driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final void setDriftInformation(StackDriftInformation.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        public Stack build() {
            return new Stack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stack> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder deletionTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().applyMutation(rollbackConfiguration)).build());
        }

        public Builder stackStatus(String var1);

        public Builder stackStatus(StackStatus var1);

        public Builder stackStatusReason(String var1);

        public Builder disableRollback(Boolean var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder roleARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableTerminationProtection(Boolean var1);

        public Builder parentId(String var1);

        public Builder rootId(String var1);

        public Builder driftInformation(StackDriftInformation var1);

        default public Builder driftInformation(Consumer<StackDriftInformation.Builder> driftInformation) {
            return this.driftInformation((StackDriftInformation)((StackDriftInformation.Builder)StackDriftInformation.builder().applyMutation(driftInformation)).build());
        }
    }
}

