/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>ListStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStacksRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStacksRequest.Builder, ListStacksRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStacksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> STACK_STATUS_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListStacksRequest::stackStatusFiltersAsStrings))
            .setter(setter(Builder::stackStatusFiltersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STACK_STATUS_FILTERS_FIELD));

    private final String nextToken;

    private final List<String> stackStatusFilters;

    private ListStacksRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.stackStatusFilters = builder.stackStatusFilters;
    }

    /**
     * <p>
     * A string that identifies the next page of stacks that you want to retrieve.
     * </p>
     * 
     * @return A string that identifies the next page of stacks that you want to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified
     * status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the
     * <a>Stack</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackStatusFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
     *         specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
     *         parameter of the <a>Stack</a> data type.
     */
    public List<StackStatus> stackStatusFilters() {
        return StackStatusFilterCopier.copyStringToEnum(stackStatusFilters);
    }

    /**
     * Returns true if the StackStatusFilters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStackStatusFilters() {
        return stackStatusFilters != null && !(stackStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified
     * status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the
     * <a>Stack</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackStatusFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
     *         specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
     *         parameter of the <a>Stack</a> data type.
     */
    public List<String> stackStatusFiltersAsStrings() {
        return stackStatusFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusFiltersAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksRequest)) {
            return false;
        }
        ListStacksRequest other = (ListStacksRequest) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(stackStatusFiltersAsStrings(), other.stackStatusFiltersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStacksRequest").add("NextToken", nextToken())
                .add("StackStatusFilters", stackStatusFiltersAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "stackStatusFilters":
            return Optional.ofNullable(clazz.cast(stackStatusFiltersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStacksRequest, T> g) {
        return obj -> g.apply((ListStacksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStacksRequest> {
        /**
         * <p>
         * A string that identifies the next page of stacks that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string that identifies the next page of stacks that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFiltersWithStrings(Collection<String> stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFiltersWithStrings(String... stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFilters(Collection<StackStatus> stackStatusFilters);

        /**
         * <p>
         * Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         * specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter
         * of the <a>Stack</a> data type.
         * </p>
         * 
         * @param stackStatusFilters
         *        Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the
         *        specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code>
         *        parameter of the <a>Stack</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusFilters(StackStatus... stackStatusFilters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> stackStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksRequest model) {
            super(model);
            nextToken(model.nextToken);
            stackStatusFiltersWithStrings(model.stackStatusFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getStackStatusFiltersAsStrings() {
            return stackStatusFilters;
        }

        @Override
        public final Builder stackStatusFiltersWithStrings(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFiltersWithStrings(String... stackStatusFilters) {
            stackStatusFiltersWithStrings(Arrays.asList(stackStatusFilters));
            return this;
        }

        @Override
        public final Builder stackStatusFilters(Collection<StackStatus> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copyEnumToString(stackStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackStatusFilters(StackStatus... stackStatusFilters) {
            stackStatusFilters(Arrays.asList(stackStatusFilters));
            return this;
        }

        public final void setStackStatusFiltersWithStrings(Collection<String> stackStatusFilters) {
            this.stackStatusFilters = StackStatusFilterCopier.copy(stackStatusFilters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStacksRequest build() {
            return new ListStacksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
