/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;

public class UpdateStackRequestMarshaller
implements Marshaller<Request<UpdateStackRequest>, UpdateStackRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<UpdateStackRequest> marshall(UpdateStackRequest updateStackRequest) {
        List<Tag> tagsList;
        List<String> list;
        RollbackConfiguration rollbackConfiguration;
        List<String> resourceTypesList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (updateStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)updateStackRequest.stackName()));
        }
        if (updateStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackRequest.templateBody()));
        }
        if (updateStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackRequest.templateURL()));
        }
        if (updateStackRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackRequest.usePreviousTemplate()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateBody() != null) {
            request.addParameter("StackPolicyDuringUpdateBody", StringUtils.fromString((String)updateStackRequest.stackPolicyDuringUpdateBody()));
        }
        if (updateStackRequest.stackPolicyDuringUpdateURL() != null) {
            request.addParameter("StackPolicyDuringUpdateURL", StringUtils.fromString((String)updateStackRequest.stackPolicyDuringUpdateURL()));
        }
        if ((parametersList = updateStackRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = updateStackRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((resourceTypesList = updateStackRequest.resourceTypes()) != null) {
            if (!resourceTypesList.isEmpty()) {
                boolean bl = true;
                for (String resourceTypesListValue : resourceTypesList) {
                    void var6_12;
                    if (resourceTypesListValue != null) {
                        request.addParameter("ResourceTypes.member." + (int)var6_12, StringUtils.fromString((String)resourceTypesListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (updateStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)updateStackRequest.roleARN()));
        }
        if ((rollbackConfiguration = updateStackRequest.rollbackConfiguration()) != null) {
            List<RollbackTrigger> list2 = rollbackConfiguration.rollbackTriggers();
            if (list2 != null) {
                if (!list2.isEmpty()) {
                    int rollbackTriggersListIndex = 1;
                    for (RollbackTrigger rollbackTriggersListValue : list2) {
                        if (rollbackTriggersListValue.arn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString((String)rollbackTriggersListValue.arn()));
                        }
                        if (rollbackTriggersListValue.type() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString((String)rollbackTriggersListValue.type()));
                        }
                        ++rollbackTriggersListIndex;
                    }
                } else {
                    request.addParameter("RollbackConfiguration.RollbackTriggers", "");
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if (updateStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)updateStackRequest.stackPolicyBody()));
        }
        if (updateStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)updateStackRequest.stackPolicyURL()));
        }
        if ((list = updateStackRequest.notificationARNs()) != null) {
            if (!list.isEmpty()) {
                int notificationARNsListIndex = 1;
                for (String notificationARNsListValue : list) {
                    if (notificationARNsListValue != null) {
                        request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                    }
                    ++notificationARNsListIndex;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((tagsList = updateStackRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (updateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)updateStackRequest.clientRequestToken()));
        }
        return request;
    }
}

