/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ImportsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListImportsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListImportsResponse> {
    private final List<String> imports;
    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.imports = builder.imports;
        this.nextToken = builder.nextToken;
    }

    public List<String> imports() {
        return this.imports;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imports());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse)((Object)obj);
        return Objects.equals(this.imports(), other.imports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.imports() != null) {
            sb.append("Imports: ").append(this.imports()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Imports": {
                return Optional.of(clazz.cast(this.imports()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<String> imports;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            this.imports(model.imports);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getImports() {
            return this.imports;
        }

        @Override
        public final Builder imports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(String ... imports) {
            this.imports(Arrays.asList(imports));
            return this;
        }

        public final void setImports(Collection<String> imports) {
            this.imports = ImportsCopier.copy(imports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListImportsResponse> {
        public Builder imports(Collection<String> var1);

        public Builder imports(String ... var1);

        public Builder nextToken(String var1);
    }
}

