/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.AccountLimit;
import software.amazon.awssdk.services.cloudformation.model.AccountLimitListCopier;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountLimitsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private final List<AccountLimit> accountLimits;
    private final String nextToken;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLimits = builder.accountLimits;
        this.nextToken = builder.nextToken;
    }

    public List<AccountLimit> accountLimits() {
        return this.accountLimits;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        return Objects.equals(this.accountLimits(), other.accountLimits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountLimits() != null) {
            sb.append("AccountLimits: ").append(this.accountLimits()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLimits": {
                return Optional.of(clazz.cast(this.accountLimits()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<AccountLimit> accountLimits;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            this.accountLimits(model.accountLimits);
            this.nextToken(model.nextToken);
        }

        public final Collection<AccountLimit.Builder> getAccountLimits() {
            return this.accountLimits != null ? (Collection)this.accountLimits.stream().map(AccountLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(AccountLimit ... accountLimits) {
            this.accountLimits(Arrays.asList(accountLimits));
            return this;
        }

        public final void setAccountLimits(Collection<AccountLimit.BuilderImpl> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copyFromBuilder(accountLimits);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder accountLimits(Collection<AccountLimit> var1);

        public Builder accountLimits(AccountLimit ... var1);

        public Builder nextToken(String var1);
    }
}

