/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;

public class ListStackSetsRequestMarshaller
implements Marshaller<Request<ListStackSetsRequest>, ListStackSetsRequest> {
    public Request<ListStackSetsRequest> marshall(ListStackSetsRequest listStackSetsRequest) {
        if (listStackSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStackSetsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listStackSetsRequest.nextToken()));
        }
        if (listStackSetsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)listStackSetsRequest.maxResults()));
        }
        if (listStackSetsRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)listStackSetsRequest.statusString()));
        }
        return request;
    }
}

