/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;

public final class ListImportsPaginator
implements SdkIterable<ListImportsResponse> {
    private final CloudFormationClient client;
    private final ListImportsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListImportsPaginator(CloudFormationClient client, ListImportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImportsResponseFetcher();
    }

    public Iterator<ListImportsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> imports() {
        Function<ListImportsResponse, Iterator> getIterator = response -> response != null ? response.imports().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListImportsResponseFetcher
    implements NextPageFetcher<ListImportsResponse> {
        private ListImportsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListImportsResponse nextPage(ListImportsResponse previousPage) {
            if (previousPage == null) {
                return ListImportsPaginator.this.client.listImports(ListImportsPaginator.this.firstRequest);
            }
            return ListImportsPaginator.this.client.listImports((ListImportsRequest)((Object)ListImportsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

