/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudformation.model.ChangeSource;
import software.amazon.awssdk.services.cloudformation.model.EvaluationType;
import software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceChangeDetail
implements ToCopyableBuilder<Builder, ResourceChangeDetail> {
    private final ResourceTargetDefinition target;
    private final String evaluation;
    private final String changeSource;
    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.changeSource = builder.changeSource;
        this.causingEntity = builder.causingEntity;
    }

    public ResourceTargetDefinition target() {
        return this.target;
    }

    public EvaluationType evaluation() {
        return EvaluationType.fromValue(this.evaluation);
    }

    public String evaluationString() {
        return this.evaluation;
    }

    public ChangeSource changeSource() {
        return ChangeSource.fromValue(this.changeSource);
    }

    public String changeSourceString() {
        return this.changeSource;
    }

    public String causingEntity() {
        return this.causingEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSourceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.causingEntity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.evaluationString(), other.evaluationString()) && Objects.equals(this.changeSourceString(), other.changeSourceString()) && Objects.equals(this.causingEntity(), other.causingEntity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.target() != null) {
            sb.append("Target: ").append(this.target()).append(",");
        }
        if (this.evaluationString() != null) {
            sb.append("Evaluation: ").append(this.evaluationString()).append(",");
        }
        if (this.changeSourceString() != null) {
            sb.append("ChangeSource: ").append(this.changeSourceString()).append(",");
        }
        if (this.causingEntity() != null) {
            sb.append("CausingEntity: ").append(this.causingEntity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.of(clazz.cast(this.target()));
            }
            case "Evaluation": {
                return Optional.of(clazz.cast(this.evaluationString()));
            }
            case "ChangeSource": {
                return Optional.of(clazz.cast(this.changeSourceString()));
            }
            case "CausingEntity": {
                return Optional.of(clazz.cast(this.causingEntity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceTargetDefinition target;
        private String evaluation;
        private String changeSource;
        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            this.target(model.target);
            this.evaluation(model.evaluation);
            this.changeSource(model.changeSource);
            this.causingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getEvaluation() {
            return this.evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final String getChangeSource() {
            return this.changeSource;
        }

        @Override
        public final Builder changeSource(String changeSource) {
            this.changeSource = changeSource;
            return this;
        }

        @Override
        public final Builder changeSource(ChangeSource changeSource) {
            this.changeSource(changeSource.toString());
            return this;
        }

        public final void setChangeSource(String changeSource) {
            this.changeSource = changeSource;
        }

        public final String getCausingEntity() {
            return this.causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChangeDetail> {
        public Builder target(ResourceTargetDefinition var1);

        default public Builder target(Consumer<ResourceTargetDefinition.Builder> target) {
            return this.target((ResourceTargetDefinition)((ResourceTargetDefinition.Builder)ResourceTargetDefinition.builder().apply(target)).build());
        }

        public Builder evaluation(String var1);

        public Builder evaluation(EvaluationType var1);

        public Builder changeSource(String var1);

        public Builder changeSource(ChangeSource var1);

        public Builder causingEntity(String var1);
    }
}

