/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.StackSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStacksResponse> {
    private final List<StackSummary> stackSummaries;
    private final String nextToken;

    private ListStacksResponse(BuilderImpl builder) {
        this.stackSummaries = builder.stackSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackSummary> stackSummaries() {
        return this.stackSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksResponse)) {
            return false;
        }
        ListStacksResponse other = (ListStacksResponse)((Object)obj);
        return Objects.equals(this.stackSummaries(), other.stackSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackSummaries() != null) {
            sb.append("StackSummaries: ").append(this.stackSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSummaries": {
                return Optional.of(clazz.cast(this.stackSummaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<StackSummary> stackSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksResponse model) {
            this.stackSummaries(model.stackSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackSummary.Builder> getStackSummaries() {
            return this.stackSummaries != null ? (Collection)this.stackSummaries.stream().map(StackSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSummaries(StackSummary ... stackSummaries) {
            this.stackSummaries(Arrays.asList(stackSummaries));
            return this;
        }

        public final void setStackSummaries(Collection<StackSummary.BuilderImpl> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copyFromBuilder(stackSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListStacksResponse build() {
            return new ListStacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStacksResponse> {
        public Builder stackSummaries(Collection<StackSummary> var1);

        public Builder stackSummaries(StackSummary ... var1);

        public Builder nextToken(String var1);
    }
}

