/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetTemplateRequest> {
    private final String stackName;
    private final String changeSetName;
    private final String templateStage;

    private GetTemplateRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.templateStage = builder.templateStage;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public TemplateStage templateStage() {
        return TemplateStage.fromValue(this.templateStage);
    }

    public String templateStageString() {
        return this.templateStage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateStageString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.templateStageString(), other.templateStageString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.templateStageString() != null) {
            sb.append("TemplateStage: ").append(this.templateStageString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "ChangeSetName": {
                return Optional.of(clazz.cast(this.changeSetName()));
            }
            case "TemplateStage": {
                return Optional.of(clazz.cast(this.templateStageString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String changeSetName;
        private String templateStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            this.stackName(model.stackName);
            this.changeSetName(model.changeSetName);
            this.templateStage(model.templateStage);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getTemplateStage() {
            return this.templateStage;
        }

        @Override
        public final Builder templateStage(String templateStage) {
            this.templateStage = templateStage;
            return this;
        }

        @Override
        public final Builder templateStage(TemplateStage templateStage) {
            this.templateStage(templateStage.toString());
            return this;
        }

        public final void setTemplateStage(String templateStage) {
            this.templateStage = templateStage;
        }

        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTemplateRequest> {
        public Builder stackName(String var1);

        public Builder changeSetName(String var1);

        public Builder templateStage(String var1);

        public Builder templateStage(TemplateStage var1);
    }
}

