/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteChangeSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteChangeSetRequest> {
    private final String changeSetName;
    private final String stackName;

    private DeleteChangeSetRequest(BuilderImpl builder) {
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String stackName() {
        return this.stackName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChangeSetRequest)) {
            return false;
        }
        DeleteChangeSetRequest other = (DeleteChangeSetRequest)((Object)obj);
        return Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.stackName(), other.stackName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetName": {
                return Optional.of(clazz.cast(this.changeSetName()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String changeSetName;
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChangeSetRequest model) {
            this.changeSetName(model.changeSetName);
            this.stackName(model.stackName);
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public DeleteChangeSetRequest build() {
            return new DeleteChangeSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteChangeSetRequest> {
        public Builder changeSetName(String var1);

        public Builder stackName(String var1);
    }
}

