/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.waiters.ChangeSetCreateComplete;
import software.amazon.awssdk.services.cloudformation.waiters.DescribeChangeSetFunction;
import software.amazon.awssdk.services.cloudformation.waiters.DescribeStacksFunction;
import software.amazon.awssdk.services.cloudformation.waiters.StackCreateComplete;
import software.amazon.awssdk.services.cloudformation.waiters.StackDeleteComplete;
import software.amazon.awssdk.services.cloudformation.waiters.StackExists;
import software.amazon.awssdk.services.cloudformation.waiters.StackUpdateComplete;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class CloudFormationClientWaiters {
    private final CloudFormationClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public CloudFormationClientWaiters(CloudFormationClient client) {
        this.client = client;
    }

    public Waiter<DescribeStacksRequest> stackExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new StackExists.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackCreateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackCreateComplete.IsCREATE_COMPLETEMatcher(), new StackCreateComplete.IsCREATE_FAILEDMatcher(), new StackCreateComplete.IsDELETE_COMPLETEMatcher(), new StackCreateComplete.IsDELETE_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_COMPLETEMatcher(), new StackCreateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeChangeSetRequest> changeSetCreateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChangeSetFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChangeSetCreateComplete.IsCREATE_COMPLETEMatcher(), new ChangeSetCreateComplete.IsFAILEDMatcher(), new ChangeSetCreateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackDeleteComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackDeleteComplete.IsDELETE_COMPLETEMatcher(), new StackDeleteComplete.IsValidationErrorMatcher(), new StackDeleteComplete.IsDELETE_FAILEDMatcher(), new StackDeleteComplete.IsCREATE_FAILEDMatcher(), new StackDeleteComplete.IsROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_IN_PROGRESSMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackUpdateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackUpdateComplete.IsUPDATE_COMPLETEMatcher(), new StackUpdateComplete.IsUPDATE_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_COMPLETEMatcher(), new StackUpdateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

