/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeStackResourcesRequestMarshaller
implements Marshaller<Request<DescribeStackResourcesRequest>, DescribeStackResourcesRequest> {
    public Request<DescribeStackResourcesRequest> marshall(DescribeStackResourcesRequest describeStackResourcesRequest) {
        if (describeStackResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStackResourcesRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackResources");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStackResourcesRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)describeStackResourcesRequest.stackName()));
        }
        if (describeStackResourcesRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringUtils.fromString((String)describeStackResourcesRequest.logicalResourceId()));
        }
        if (describeStackResourcesRequest.physicalResourceId() != null) {
            request.addParameter("PhysicalResourceId", StringUtils.fromString((String)describeStackResourcesRequest.physicalResourceId()));
        }
        return request;
    }
}

