/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.util.StringUtils;

public class ValidateTemplateRequestMarshaller
implements Marshaller<Request<ValidateTemplateRequest>, ValidateTemplateRequest> {
    public Request<ValidateTemplateRequest> marshall(ValidateTemplateRequest validateTemplateRequest) {
        if (validateTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)validateTemplateRequest, "CloudFormationClient");
        request.addParameter("Action", "ValidateTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (validateTemplateRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)validateTemplateRequest.templateBody()));
        }
        if (validateTemplateRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)validateTemplateRequest.templateURL()));
        }
        return request;
    }
}

