/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TemplateParameter
implements ToCopyableBuilder<Builder, TemplateParameter> {
    private final String parameterKey;
    private final String defaultValue;
    private final Boolean noEcho;
    private final String description;

    private TemplateParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Boolean noEcho() {
        return this.noEcho;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterKey() == null ? 0 : this.parameterKey().hashCode());
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        hashCode = 31 * hashCode + (this.noEcho() == null ? 0 : this.noEcho().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameter)) {
            return false;
        }
        TemplateParameter other = (TemplateParameter)obj;
        if (other.parameterKey() == null ^ this.parameterKey() == null) {
            return false;
        }
        if (other.parameterKey() != null && !other.parameterKey().equals(this.parameterKey())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        if (other.noEcho() == null ^ this.noEcho() == null) {
            return false;
        }
        if (other.noEcho() != null && !other.noEcho().equals(this.noEcho())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterKey() != null) {
            sb.append("ParameterKey: ").append(this.parameterKey()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.noEcho() != null) {
            sb.append("NoEcho: ").append(this.noEcho()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String defaultValue;
        private Boolean noEcho;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameter model) {
            this.setParameterKey(model.parameterKey);
            this.setDefaultValue(model.defaultValue);
            this.setNoEcho(model.noEcho);
            this.setDescription(model.description);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public TemplateParameter build() {
            return new TemplateParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TemplateParameter> {
        public Builder parameterKey(String var1);

        public Builder defaultValue(String var1);

        public Builder noEcho(Boolean var1);

        public Builder description(String var1);
    }
}

