/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.jmespath.JmesPathEvaluationVisitor;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathFlatten;
import software.amazon.awssdk.jmespath.JmesPathProjection;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.jmespath.ObjectMapperSingleton;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class StackUpdateComplete {
    StackUpdateComplete() {
    }

    static class IsValidationErrorMatcher
    extends WaiterAcceptor<DescribeStacksResponse> {
        IsValidationErrorMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ValidationError".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsUPDATE_ROLLBACK_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsUPDATE_ROLLBACK_COMPLETEMatcher() {
        }

        public boolean matches(DescribeStacksResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_ROLLBACK_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Stacks")), (JmesPathExpression)new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_ROLLBACK_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsUPDATE_ROLLBACK_FAILEDMatcher() {
        }

        public boolean matches(DescribeStacksResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_ROLLBACK_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Stacks")), (JmesPathExpression)new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsUPDATE_FAILEDMatcher() {
        }

        public boolean matches(DescribeStacksResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Stacks")), (JmesPathExpression)new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsUPDATE_COMPLETEMatcher() {
        }

        public boolean matches(DescribeStacksResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Stacks")), (JmesPathExpression)new JmesPathField("StackStatus"));
        }
    }
}

